/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.utils;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.w3c.dom.NodeList;

public class ImageProcessingUtils {
    private static final int NUM_THREADS = Runtime.getRuntime().availableProcessors();

    public static void processImages(NodeList imgs, String agilitestTempResourcesPath) {
        try (ExecutorService executor = Executors.newFixedThreadPool(NUM_THREADS);){
            for (int i = 0; i < imgs.getLength(); ++i) {
                if (imgs.item(i).getAttributes().getNamedItem("src") == null) continue;
                String src = imgs.item(i).getAttributes().getNamedItem("src").getNodeValue();
                String type = FileUtils.getFileType(src);
                Object name = imgs.item(i).getAttributes().getNamedItem("id") == null ? "screen_" + i : imgs.item(i).getAttributes().getNamedItem("id").getNodeValue();
                executor.submit(new ImageProcessor(src, (String)name, agilitestTempResourcesPath, type));
                if (!type.equals("mpeg")) {
                    imgs.item(i).getAttributes().getNamedItem("src").setNodeValue(agilitestTempResourcesPath + File.separator + (String)name + "." + type);
                }
                imgs.item(i).getAttributes().getNamedItem("type").setNodeValue(type);
            }
            executor.shutdown();
        }
    }

    public static void processVideos(String atsTestReportPath, File agilitestTempResourceFile, String agilitestTempResourcesPath) throws IOException {
        List<String> videosToBeProcessed = Arrays.stream(Objects.requireNonNull(agilitestTempResourceFile.listFiles())).filter(file -> file.getName().endsWith("mpeg")).map(file -> "videoPlaceholder" + file.getName().replace(".mpeg", "")).collect(Collectors.toList());
        if (!videosToBeProcessed.isEmpty()) {
            AtsLogger.printLog("processing " + videosToBeProcessed.size() + " video file(s)");
            ImageProcessingUtils.replaceStringsInFile(atsTestReportPath, videosToBeProcessed, agilitestTempResourcesPath);
        }
    }

    private static void replaceStringsInFile(String filePath, List<String> oldStrings, String agilitestTempResourcesPath) {
        File inputFile = new File(filePath);
        File outputFile = new File(filePath + ".tmp");
        try (FileInputStream inputStream = new FileInputStream(inputFile);
             FileOutputStream outputStream = new FileOutputStream(outputFile);){
            int bytesRead;
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            for (String oldString : oldStrings) {
                String replacementString = Base64.getEncoder().encodeToString(Files.readAllBytes(Path.of(agilitestTempResourcesPath + File.separator + oldString.replace("videoPlaceholder", "") + ".mpeg", new String[0])));
                replacementMap.put(oldString, replacementString);
            }
            byte[] buffer = new byte[4096];
            StringBuilder currentLine = new StringBuilder();
            while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                for (int i = 0; i < bytesRead; ++i) {
                    if (buffer[i] == 10 || buffer[i] == 13) {
                        ImageProcessingUtils.processLine(currentLine.toString(), outputStream, replacementMap);
                        currentLine.setLength(0);
                        continue;
                    }
                    currentLine.append((char)buffer[i]);
                }
            }
            ImageProcessingUtils.processLine(currentLine.toString(), outputStream, replacementMap);
        }
        catch (IOException | OutOfMemoryError e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (inputFile.delete()) {
            outputFile.renameTo(inputFile);
        }
    }

    private static void processLine(String line, OutputStream outputStream, Map<String, String> replacements) throws IOException {
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            line = line.replace(entry.getKey(), entry.getValue());
        }
        outputStream.write(line.getBytes());
        outputStream.write(10);
    }

    private static class ImageProcessor
    implements Callable<Void> {
        private final String src;
        private final String name;
        private final String tempResourcesPath;
        private final String type;

        public ImageProcessor(String src, String name, String tempResourcesPath, String type) {
            this.src = src;
            this.name = name;
            this.tempResourcesPath = tempResourcesPath;
            this.type = type;
        }

        @Override
        public Void call() {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] decode = decoder.decode(this.src);
            try (FileOutputStream fos = new FileOutputStream(this.tempResourcesPath + File.separator + this.name + "." + this.type);){
                fos.write(decode);
            }
            catch (IOException e) {
                AtsLogger.printLog("error saving file: " + e.getMessage());
            }
            return null;
        }
    }
}

