/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.parsers;

import com.ats.generator.GeneratorReport;
import com.ats.generator.events.ScriptProcessedNotifier;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.generator.variables.BaseValue;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.EnvironmentValue;
import com.ats.generator.variables.ParameterValue;
import com.ats.generator.variables.Variable;
import com.ats.script.AtsScript;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.script.actions.ActionAI;
import com.ats.script.actions.ActionApi;
import com.ats.script.actions.ActionAssertCount;
import com.ats.script.actions.ActionAssertProperty;
import com.ats.script.actions.ActionAssertValue;
import com.ats.script.actions.ActionButton;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionChannelClose;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionChannelSwitch;
import com.ats.script.actions.ActionComment;
import com.ats.script.actions.ActionFileTransfer;
import com.ats.script.actions.ActionGesturePress;
import com.ats.script.actions.ActionGestureTap;
import com.ats.script.actions.ActionGotoUrl;
import com.ats.script.actions.ActionMouse;
import com.ats.script.actions.ActionMouseDragDrop;
import com.ats.script.actions.ActionMouseKey;
import com.ats.script.actions.ActionMouseScroll;
import com.ats.script.actions.ActionMouseSwipe;
import com.ats.script.actions.ActionProperty;
import com.ats.script.actions.ActionPropertySet;
import com.ats.script.actions.ActionScripting;
import com.ats.script.actions.ActionSelect;
import com.ats.script.actions.ActionText;
import com.ats.script.actions.ActionWindowNew;
import com.ats.script.actions.ActionWindowResize;
import com.ats.script.actions.ActionWindowState;
import com.ats.script.actions.ActionWindowSwitch;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.script.actions.neoload.ActionNeoloadContainer;
import com.ats.script.actions.neoload.ActionNeoloadRecord;
import com.ats.script.actions.neoload.ActionNeoloadRun;
import com.ats.script.actions.network.ActionNetworkRecord;
import com.ats.script.actions.network.ActionNetworkSettings;
import com.ats.script.actions.network.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.Operators;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Lexer {
    private final Pattern ACTION_PATTERN = Pattern.compile("(.*)\\[(.*?)\\]", 2);
    private final String FILE_TYPE = "#file";
    private final String PARAMETERS_TYPE = "#params";
    private final String TABLE_TYPE = "#table";
    private GeneratorReport report;
    private Project projectData;
    private Charset charset = StandardCharsets.UTF_8;
    public int countScript = 0;
    private boolean isGenerator = true;

    public boolean isGenerator() {
        return this.isGenerator;
    }

    public Lexer(GeneratorReport report) {
        this.isGenerator = false;
        this.report = report;
    }

    public Lexer(Project projectData, GeneratorReport report, String charset) {
        this.projectData = projectData;
        this.report = report;
        try {
            this.charset = Charset.forName(charset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Lexer(Project projectData, GeneratorReport report, Charset charset) {
        this.projectData = projectData;
        this.report = report;
        this.charset = charset;
    }

    public void addScript() {
        ++this.countScript;
    }

    public AtsScript loadScript(File f, ScriptProcessedNotifier notifier) {
        AtsScript script = this.getScript(f);
        notifier.scriptProcessed();
        return script;
    }

    public AtsScript loadScript(String content) {
        return new AtsScript(this, content, this.projectData);
    }

    public AtsScript loadScript(File f) {
        return this.getScript(f);
    }

    private AtsScript getScript(File f) {
        if (f.exists() && f.isFile()) {
            return new AtsScript("ats", this, f, this.projectData, this.charset);
        }
        return null;
    }

    public void createAction(AtsScript script, String data, boolean disabled) {
        ArrayList<String> dataArray = new ArrayList<String>(Arrays.asList(data.split("->")));
        if (dataArray.size() > 0) {
            ExecuteOptions options = new ExecuteOptions();
            String actionType = options.init(script, dataArray.remove(0).trim(), this.ACTION_PATTERN);
            int stopPolicy = options.getStopPolicy();
            if (ActionGesturePress.PREDICATE.test(actionType)) {
                String elementInfo = dataArray.remove(dataArray.size() - 1).trim();
                ArrayList<String> elements = new ArrayList<String>(Arrays.asList(elementInfo));
                script.addAction(new ActionGesturePress((Script)script, options, stopPolicy, dataArray, elements), disabled);
            } else if (Mouse.PREDICATE_OVER.test(actionType)) {
                script.addAction(new ActionMouse(script, options, "over", stopPolicy, dataArray), disabled);
            } else if (Mouse.PREDICATE_DRAG_DROP.test(actionType)) {
                script.addAction(new ActionMouseDragDrop(script, options, actionType, stopPolicy, dataArray), disabled);
            } else if (Mouse.PREDICATE_CLICK.test(actionType)) {
                script.addAction(new ActionMouseKey(script, options, actionType, stopPolicy, dataArray), disabled);
            } else if (ActionChannelClose.PREDICATE.test(actionType)) {
                String cname = "";
                if (dataArray.size() > 0) {
                    cname = dataArray.remove(0).trim();
                }
                script.addAction(new ActionChannelClose(script, options, cname), disabled);
            } else if (ActionNetworkRecord.PREDICATE.test(actionType)) {
                if (dataArray.size() > 0) {
                    script.addAction(new ActionNetworkRecord(script, dataArray.remove(0).trim()), disabled);
                }
            } else if (ActionNetworkSettings.PREDICATE.test(actionType)) {
                script.addAction(new ActionNetworkSettings(script, options, dataArray), disabled);
            } else if (ActionOctoperfVirtualUser.PREDICATE.test(actionType)) {
                if (dataArray.size() > 0) {
                    script.addAction(new ActionOctoperfVirtualUser(script, options, dataArray), disabled);
                }
            } else if (!ActionNeoloadRun.PREDICATE.test(actionType)) {
                if (ActionComment.PREDICATE.test(actionType)) {
                    script.addAction(new ActionComment(script, actionType, dataArray), disabled);
                } else if (ActionText.PREDICATE.test(actionType)) {
                    String dataText = "";
                    if (dataArray.size() > 0) {
                        dataText = dataArray.remove(0).trim();
                    }
                    script.addAction(new ActionText(script, options, stopPolicy, dataText, dataArray), disabled);
                } else if (dataArray.size() > 0) {
                    String dataOne = dataArray.remove(0).trim();
                    if (ActionPropertySet.PREDICATE.test(actionType)) {
                        String propertyValue = "";
                        if (dataArray.size() > 0) {
                            propertyValue = dataArray.remove(0).trim();
                        }
                        script.addAction(new ActionPropertySet((Script)script, options, dataOne, propertyValue), disabled);
                    } else if (ActionButton.PREDICATE.test(actionType)) {
                        script.addAction(new ActionButton(script, options, dataOne), disabled);
                    } else if (ActionGestureTap.PREDICATE.test(actionType)) {
                        script.addAction(new ActionGestureTap((Script)script, options, dataOne, stopPolicy, dataArray), disabled);
                    } else if (ActionChannelSwitch.PREDICATE.test(actionType)) {
                        script.addAction(new ActionChannelSwitch(script, options, dataOne), disabled);
                    } else if (ActionChannelStart.PREDICATE.test(actionType)) {
                        if (!dataArray.isEmpty()) {
                            script.addAction(new ActionChannelStart(script, options, dataOne, new CalculatedValue(script, dataArray.removeFirst().trim()), dataArray), disabled);
                        }
                    } else if (ActionApi.PREDICATE.test(actionType)) {
                        String headerData = "";
                        Matcher matcher = this.ACTION_PATTERN.matcher(dataOne);
                        if (matcher.find()) {
                            dataOne = matcher.group(1).trim();
                            headerData = matcher.group(2).trim();
                        }
                        script.addAction(new ActionApi(script, options, actionType, dataOne, headerData, dataArray), disabled);
                    } else if (ActionWindowResize.PREDICATE.test(actionType)) {
                        script.addAction(new ActionWindowResize(script, options, dataOne), disabled);
                    } else if (ActionWindowState.PREDICATE_STATE.test(actionType)) {
                        script.addAction(new ActionWindowState(script, options, dataOne), disabled);
                    } else if (ActionWindowNew.PREDICATE.test(actionType)) {
                        script.addAction(new ActionWindowNew((Script)script, options, dataOne, dataArray), disabled);
                    } else if (ActionWindowSwitch.PREDICATE.test(actionType)) {
                        boolean regexp = false;
                        String type = "index";
                        String dataValue = dataOne;
                        if (dataArray.size() > 0) {
                            if ("index".equalsIgnoreCase(dataOne) || "name".equalsIgnoreCase(dataOne) || "url".equalsIgnoreCase(dataOne)) {
                                type = dataOne.toLowerCase();
                                dataValue = dataArray.get(0).trim();
                            }
                        } else {
                            dataValue = "0";
                            int separator = dataOne.indexOf("=~");
                            if (separator == -1) {
                                separator = dataOne.indexOf("=");
                            }
                            if (separator > 0) {
                                String testType = dataOne.substring(0, separator).trim();
                                if ("index".equalsIgnoreCase(testType) || "name".equalsIgnoreCase(testType) || "url".equalsIgnoreCase(testType)) {
                                    type = testType.toLowerCase();
                                    dataValue = dataOne.substring(separator + 1).trim();
                                    if (dataValue.startsWith("~")) {
                                        dataValue = dataValue.substring(1).trim();
                                        if (!testType.equals("index")) {
                                            regexp = true;
                                        }
                                    }
                                }
                            } else {
                                dataValue = dataOne;
                            }
                        }
                        script.addAction(new ActionWindowSwitch(script, options, new CalculatedValue(script, dataValue), type, regexp), disabled);
                    } else if (ActionWindowState.PREDICATE_CLOSE.test(actionType)) {
                        script.addAction(new ActionWindowState(script, options, "close"), disabled);
                    } else if (ActionScripting.PREDICATE.test(actionType)) {
                        String[] jsDataArray = dataOne.split("=>");
                        if (jsDataArray.length > 0) {
                            Variable variable = null;
                            String jsCode = jsDataArray[0].trim();
                            if (jsDataArray.length > 1) {
                                variable = script.getVariable(jsDataArray[1].trim(), true);
                            }
                            script.addAction(new ActionScripting(script, options, stopPolicy, jsCode, variable, dataArray), disabled);
                        }
                    } else if (ActionProperty.PREDICATE.test(actionType)) {
                        String[] propertyArray = dataOne.split("=>");
                        if (propertyArray.length > 1) {
                            String propertyName = propertyArray[0].trim();
                            Variable variable = script.getVariable(propertyArray[1].trim(), true);
                            script.addAction(new ActionProperty((Script)script, options, stopPolicy, propertyName, variable, dataArray), disabled);
                        }
                    } else if (ActionSelect.PREDICATE.test(actionType)) {
                        script.addAction(new ActionSelect(script, options, dataOne, stopPolicy, dataArray), disabled);
                    } else if (ActionCallscript.PREDICATE_OLD.test(actionType)) {
                        String[] parameters = new String[]{};
                        String[] returnValues = new String[]{};
                        String csvFilePath = null;
                        if (dataOne.contains("=>")) {
                            String[] callscriptData = dataOne.split("=>");
                            dataOne = callscriptData[0].trim();
                            returnValues = callscriptData[1].split(",");
                        }
                        if (dataArray.size() > 0) {
                            String firstValue = dataArray.get(0).trim();
                            if (firstValue.startsWith("assets:///") || firstValue.startsWith("file://") || firstValue.startsWith("http://") || firstValue.startsWith("https://")) {
                                csvFilePath = dataArray.remove(0).trim();
                            }
                        } else {
                            Matcher matcher = this.ACTION_PATTERN.matcher(dataOne);
                            if (matcher.find()) {
                                BaseValue sp;
                                dataOne = matcher.group(1).trim();
                                String parametersData = matcher.group(2);
                                Matcher mv = CalculatedValue.PARAMETER_PATTERN.matcher(parametersData);
                                while (mv.find()) {
                                    sp = new ParameterValue(mv);
                                    parametersData = parametersData.replace(sp.getReplace(), sp.getNoComma());
                                }
                                mv = CalculatedValue.ENV_PATTERN.matcher(parametersData);
                                while (mv.find()) {
                                    sp = new EnvironmentValue(mv);
                                    parametersData = parametersData.replace(sp.getReplace(), sp.getNoComma());
                                }
                                parameters = parametersData.split(",");
                            }
                        }
                        options.checkLegacy(script);
                        script.addAction(new ActionCallscript(script, options, dataOne, parameters, returnValues, csvFilePath, dataArray), disabled, data);
                    } else if (ActionCallscript.PREDICATE.test(actionType)) {
                        String[] parameters = new String[]{};
                        String[] returnValues = new String[]{};
                        String csvFilePath = null;
                        ArrayList<String> newDataArray = new ArrayList<String>();
                        if (dataArray.size() > 0) {
                            for (String s : dataArray) {
                                int idx = s.indexOf("=>");
                                if (idx > -1) {
                                    String rVal = s.substring(idx + 2);
                                    rVal = rVal.replaceFirst("=>.*", "");
                                    returnValues = rVal.split(",");
                                    s = s.substring(0, idx);
                                    newDataArray.add(s.trim());
                                    s.split("=>");
                                    continue;
                                }
                                newDataArray.add(s.trim());
                            }
                            String firstValue = ((String)newDataArray.get(0)).trim();
                            if (firstValue.startsWith("assets:///") || firstValue.startsWith("file://") || firstValue.startsWith("http://") || firstValue.startsWith("https://")) {
                                csvFilePath = firstValue;
                            }
                        } else {
                            Matcher matcher;
                            int idx = dataOne.indexOf("=>");
                            if (idx > -1) {
                                String rVal = dataOne.substring(idx + 2);
                                returnValues = rVal.split(",");
                                dataOne = dataOne.substring(0, idx).trim();
                            }
                            if ((matcher = this.ACTION_PATTERN.matcher(dataOne)).find()) {
                                BaseValue sp;
                                dataOne = matcher.group(1).trim();
                                String parametersData = matcher.group(2);
                                Matcher mv = CalculatedValue.PARAMETER_PATTERN.matcher(parametersData);
                                while (mv.find()) {
                                    sp = new ParameterValue(mv);
                                    parametersData = parametersData.replace(sp.getReplace(), sp.getNoComma());
                                }
                                mv = CalculatedValue.ENV_PATTERN.matcher(parametersData);
                                while (mv.find()) {
                                    sp = new EnvironmentValue(mv);
                                    parametersData = parametersData.replace(sp.getReplace(), sp.getNoComma());
                                }
                                parameters = parametersData.split(",");
                            }
                        }
                        script.addAction(new ActionCallscript(script, options, dataOne, parameters, returnValues, csvFilePath, newDataArray), disabled, data);
                    } else if (ActionCallscript.PREDICATE_NEW.test(actionType)) {
                        String[] parameters = new String[]{};
                        String[] returnValues = new String[]{};
                        String csvFilePath = null;
                        if (dataOne.contains("=>")) {
                            String[] callscriptData = dataOne.split("=>");
                            dataOne = callscriptData[0].trim();
                            returnValues = StringUtils.stripAll((String[])callscriptData[1].split(","));
                        }
                        String tableSplit = null;
                        if (dataArray.size() > 1) {
                            String dataType = dataArray.remove(0).trim();
                            if ("#file".equals(dataType)) {
                                csvFilePath = dataArray.remove(0).trim();
                            } else if ("#table".equals(dataType)) {
                                if (dataArray.size() > 1) {
                                    tableSplit = dataArray.remove(0).trim();
                                    parameters = new String[]{dataArray.remove(0).trim()};
                                }
                            } else if ("#params".equals(dataType)) {
                                parameters = new String[dataArray.size()];
                                int i = 0;
                                while (dataArray.size() > 0) {
                                    parameters[i] = dataArray.remove(0);
                                    ++i;
                                }
                            }
                        }
                        script.addAction(new ActionCallscript(script, options, dataOne, parameters, returnValues, csvFilePath, dataArray, tableSplit), disabled, data);
                    } else if (ActionGotoUrl.PREDICATE.test(actionType)) {
                        script.addAction(new ActionGotoUrl(script, options, stopPolicy, new CalculatedValue(script, dataOne)), disabled);
                    } else if (ActionFileTransfer.PREDICATE.test(actionType)) {
                        script.addAction(new ActionFileTransfer(script, options, stopPolicy, actionType.toLowerCase(), dataOne, dataArray), disabled);
                    } else if (ActionAI.PREDICATE.test(actionType)) {
                        ArrayList<Variable> variableValues = new ArrayList<Variable>();
                        if (dataOne.contains("=>")) {
                            String[] callscriptData = dataOne.split("=>");
                            dataOne = callscriptData[0].trim();
                            String[] returnValues = callscriptData[1].split(",");
                            if (returnValues.length > 0) {
                                for (String varName : returnValues) {
                                    variableValues.add(script.getVariable(varName.trim(), true));
                                }
                            }
                        }
                        script.addAction(new ActionAI(script, options, new CalculatedValue(script, dataOne), variableValues), disabled);
                    } else if (ActionMouseScroll.PREDICATE.test(actionType)) {
                        script.addAction(new ActionMouseScroll(script, options, dataOne, stopPolicy, dataArray), disabled);
                    } else if (ActionMouseSwipe.PREDICATE.test(actionType)) {
                        script.addAction(new ActionMouseSwipe(script, options, actionType, dataOne, stopPolicy, dataArray), disabled);
                    } else if (ActionAssertCount.PREDICATE.test(actionType)) {
                        script.addAction(new ActionAssertCount(script, options, stopPolicy, dataOne, dataArray), disabled);
                    } else if (ActionAssertCount.PREDICATE_OCCURRENCE.test(actionType)) {
                        String op;
                        if (dataOne.length() > 1 && Operators.COMPARAISON_TYPE.contains(op = dataOne.substring(0, 2))) {
                            String calc = dataOne.substring(2).trim();
                            script.addAction(new ActionAssertCount(script, options, stopPolicy, op, calc, dataArray), disabled);
                        }
                    } else if (ActionAssertProperty.PREDICATE.test(actionType)) {
                        script.addAction(new ActionAssertProperty(script, options, stopPolicy, dataOne, dataArray), disabled);
                    } else if (ActionAssertValue.PREDICATE.test(actionType)) {
                        script.addAction(new ActionAssertValue(script, options, stopPolicy, dataOne), disabled);
                    } else if (ActionNeoloadContainer.PREDICATE.test(actionType)) {
                        if (dataOne.length() > 0) {
                            script.addAction(new ActionNeoloadContainer(script, dataOne), disabled);
                        }
                    } else if (ActionNeoloadRecord.PREDICATE.test(actionType)) {
                        script.addAction(new ActionNeoloadRecord(script, dataOne), disabled);
                    }
                } else if (!(data.startsWith("<<<<<<<") || data.startsWith("=======") || data.startsWith(">>>>>>>"))) {
                    script.addAction(new ActionComment(script, data), disabled);
                }
            }
        }
    }
}

