/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.AtsSingleton;
import com.ats.crypto.Password;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.executor.channels.Channel;
import com.ats.generator.variables.BaseValue;
import com.ats.generator.variables.EnvironmentValue;
import com.ats.generator.variables.ParameterValue;
import com.ats.generator.variables.RandomStringValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.transform.DateTransformer;
import com.ats.generator.variables.transform.TimeTransformer;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.tools.Utils;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public class CalculatedValue {
    public static final String CRYPTED_DATA_SHOW = "########";
    private static final Pattern TODAY_PATTERN = Pattern.compile("\\$today", 2);
    private static final Pattern NOW_PATTERN = Pattern.compile("\\$now", 2);
    private static final Pattern UUID_PATTERN = Pattern.compile("\\$uuid", 2);
    private static final Pattern ITERATION_PATTERN = Pattern.compile("\\$iteration", 2);
    private static final Pattern ITERATIONS_COUNT_PATTERN = Pattern.compile("\\$iterationsCount", 2);
    private static final Pattern LAST_ACTION_DURATION_PATTERN = Pattern.compile("\\$lastActionDuration", 2);
    public static final Pattern KEY_REGEXP = Pattern.compile("\\$key\\s?\\((\\w+)\\-?([^\\)]*)?\\)");
    public static final Pattern ASSET_PATTERN = Pattern.compile("\\$asset\\s*?\\(([^\\)]*)\\)", 2);
    public static final Pattern IMAGE_PATTERN = Pattern.compile("\\$image\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("\\$pass\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern PASSWORD_ENV_PATTERN = Pattern.compile("\\$pass\\s*?\\(.*\\$(.*)\\(([^\\)]*)\\).*\\)", 2);
    private static final Pattern ATS_DATA = Pattern.compile("\\$ats\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern SYS_PATTERN = Pattern.compile("\\$sys\\s*?\\(([^\\)]*)\\)", 2);
    public static final Pattern PARAMETER_PATTERN = Pattern.compile("\\$param\\s*?\\((\\$?\\w+),?(\\s*?[^\\)]*)?\\)", 2);
    public static final Pattern ENV_PATTERN = Pattern.compile("\\$env\\s*?\\(([-\\w.]+),?(\\s*?[^\\)]*)?\\)", 2);
    private static final Pattern PROJECT_VARIABLE_INNER_PATTERN = Pattern.compile("\\$prj\\s*?\\(([-\\w.]+),?(\\s*?[^\\)]*)?\\)", 2);
    private static final Pattern PROJECT_VARIABLE_MAIN_PATTERN = Pattern.compile("\\$prj\\s*?\\((.*)\\)", 2);
    private static final Pattern PROPERTY_FILE_PATTERN = Pattern.compile("\\$prop\\s*?\\((.*) *, *(.*)\\)", 2);
    private static final Pattern RND_PATTERN = Pattern.compile("\\$rnd(?:string)?\\s*?\\((\\d+),?(\\w{0,3}?[^\\)]*)?\\)", 2);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$var\\s*?\\(([^\\)\\.]*)\\)", 2);
    private static final Pattern GLOBAL_VARIABLE_PATTERN = Pattern.compile("\\$var\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern invalidUnicodePattern = Pattern.compile("[\\p{C}]");
    private static final Pattern unnecessaryStartQuotes = Pattern.compile("^\"\", ?");
    private static final Pattern unnecessaryMiddleQuotes = Pattern.compile(" \"\",");
    private static final Pattern unnecessaryEndQuotes = Pattern.compile(", \"\"$");
    private Script script;
    private String data = "";
    private String calculated;
    private String safeCalculated;
    private String rawJavaCode = "";
    private Object[] dataList;
    private boolean crypted = false;

    public CalculatedValue() {
    }

    public CalculatedValue(String value) {
        this.setData(value);
    }

    public CalculatedValue(int value) {
        this(String.valueOf(value));
    }

    public CalculatedValue(ActionTestScript actionTestScript, Object[] data) {
        this.dataList = data;
    }

    public CalculatedValue(Script script) {
        this.setScript(script);
        this.setCalculated("");
    }

    public CalculatedValue(Script script, String dataValue) {
        this.setScript(script);
        if (dataValue.length() > 0) {
            Matcher matcher = invalidUnicodePattern.matcher(dataValue);
            dataValue = Utils.unescapeAts(matcher.replaceAll(""));
            this.updateData(dataValue);
        }
    }

    public void updateData(String value) {
        this.setData(value);
        this.setCalculated(this.initCalculated(value));
    }

    private String replaceJavaCode(String javaCode, String replace, String code) {
        return javaCode.replace(replace, "\", " + code + ", \"");
    }

    private String parseVariableCode(String code) {
        BaseValue sp;
        Matcher mv = ENV_PATTERN.matcher(code);
        while (mv.find()) {
            sp = new EnvironmentValue(mv);
            code = this.replaceJavaCode(code, sp.getReplace(), "env" + sp.getCode());
        }
        mv = VARIABLE_PATTERN.matcher(code);
        while (mv.find()) {
            String replace = mv.group(0);
            String variableName = mv.group(1);
            code = this.replaceJavaCode(code, replace, variableName + ".toString()");
        }
        mv = PARAMETER_PATTERN.matcher(code);
        while (mv.find()) {
            sp = new ParameterValue(mv);
            code = this.replaceJavaCode(code, sp.getReplace(), "prm" + sp.getCode());
        }
        mv = PROJECT_VARIABLE_INNER_PATTERN.matcher(code);
        while (mv.find()) {
            sp = new EnvironmentValue(mv);
            code = this.replaceJavaCode(code, sp.getReplace(), "prj" + sp.getCode());
        }
        return code;
    }

    private String initCalculated(String dataValue) {
        String variableName;
        String relativePath;
        String assetExpression;
        BaseValue sp;
        String g1;
        String g0;
        StringBuilder sb;
        String value;
        String replace;
        this.rawJavaCode = StringEscapeUtils.escapeJava((String)dataValue);
        Matcher mv = ATS_DATA.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            value = mv.group(1).trim();
            dataValue = dataValue.replace(replace, this.script.getSpecialValue(value));
            sb = new StringBuilder("ats").append("(\"").append(value).append("\")");
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, sb.toString());
        }
        mv = ITERATIONS_COUNT_PATTERN.matcher(dataValue);
        while (mv.find()) {
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), "itc()");
        }
        mv = ITERATION_PATTERN.matcher(dataValue);
        while (mv.find()) {
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), "itr()");
        }
        mv = PROPERTY_FILE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            g0 = mv.group(0);
            g1 = mv.group(1);
            String g2 = mv.group(2);
            dataValue = dataValue.replace(g0, this.script.getPropertyVariableValue(g1, g2));
            StringBuilder sb2 = new StringBuilder("pt").append("(").append(this.getJavaCode("ct", this.parseVariableCode(g1))).append(", ").append(this.getJavaCode("ct", this.parseVariableCode(g2))).append(")");
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), sb2.toString());
        }
        mv = PROJECT_VARIABLE_MAIN_PATTERN.matcher(dataValue);
        while (mv.find()) {
            g0 = mv.group(0);
            g1 = mv.group(1);
            dataValue = dataValue.replace(g0, this.script.getProjectVariableValue(g1));
            sb = new StringBuilder("prj").append("(").append(this.getJavaCode("ct", this.parseVariableCode(g1))).append(")");
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, g0, sb.toString());
        }
        mv = PASSWORD_ENV_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            String type = mv.group(1);
            String name = mv.group(2);
            if ("env".equals(type)) {
                dataValue = dataValue.replace(replace, this.script.getPassword(this.script.getEnvironmentValue(name, "")));
                this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), "new " + Password.class.getSimpleName() + "(this, env(\"" + name + "\"))");
                continue;
            }
            if (!"param".equals(type)) continue;
            ParameterValue sp2 = new ParameterValue(name);
            String rp = sp2.getReplace();
            if (rp != null) {
                dataValue = dataValue.replace(rp, this.script.getParameterValue(sp2.getValue(), sp2.getDefaultValue()));
            }
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), "new " + Password.class.getSimpleName() + "(this, prm(\"" + name + "\"))");
        }
        mv = PASSWORD_PATTERN.matcher(dataValue);
        while (mv.find()) {
            this.crypted = true;
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), "new " + Password.class.getSimpleName() + "(this, \"" + mv.group(1) + "\")");
        }
        mv = PARAMETER_PATTERN.matcher(dataValue);
        while (mv.find()) {
            sp = new ParameterValue(mv);
            dataValue = dataValue.replace(sp.getReplace(), this.script.getParameterValue(((ParameterValue)sp).getValue(), sp.getDefaultValue()));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, sp.getReplace(), "prm" + sp.getCode());
        }
        mv = IMAGE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            assetExpression = mv.group(0);
            relativePath = mv.group(1);
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, assetExpression, Project.getAssetsImageJavaCode(relativePath));
        }
        mv = ASSET_PATTERN.matcher(dataValue);
        while (mv.find()) {
            assetExpression = mv.group(0);
            relativePath = mv.group(1);
            dataValue = dataValue.replace(assetExpression, this.script.getAssetsFilePath(relativePath));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, assetExpression, Project.getAssetsJavaCode(relativePath));
        }
        mv = VARIABLE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            variableName = mv.group(1);
            dataValue = dataValue.replace(replace, this.script.getVariableValue(variableName));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, variableName);
        }
        mv = GLOBAL_VARIABLE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            variableName = mv.group(1);
            dataValue = dataValue.replace(replace, this.script.getGlobalVariableValue(variableName));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "gvar(\"" + variableName + "\")");
        }
        mv = SYS_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            value = StringEscapeUtils.escapeJava((String)mv.group(1).trim());
            dataValue = dataValue.replace(replace, AtsSingleton.getInstance().getSystemValue(value));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "sys(\"" + value + "\")");
        }
        mv = ENV_PATTERN.matcher(dataValue);
        while (mv.find()) {
            sp = new EnvironmentValue(mv);
            dataValue = dataValue.replace(sp.getReplace(), this.script.getEnvironmentValue(((EnvironmentValue)sp).getValue(), sp.getDefaultValue()));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, sp.getReplace(), "env" + sp.getCode());
        }
        mv = TODAY_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, DateTransformer.getTodayValue());
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "td()");
        }
        mv = LAST_ACTION_DURATION_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, String.valueOf(this.script.getLastActionDuration()));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "lad()");
        }
        mv = NOW_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, TimeTransformer.getNowValue());
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "nw()");
        }
        mv = UUID_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, UUID.randomUUID().toString());
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "uid()");
        }
        mv = RND_PATTERN.matcher(dataValue);
        while (mv.find()) {
            RandomStringValue rds = new RandomStringValue(mv);
            dataValue = dataValue.replace(rds.getReplace(), rds.exec());
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, rds.getReplace(), "rds" + rds.getCode());
        }
        return dataValue;
    }

    public boolean isCrypted() {
        return this.crypted;
    }

    public void dispose() {
        this.script = null;
        this.dataList = null;
    }

    private String replaceQuotes(String code) {
        code = "\"" + (String)code + "\"";
        code = unnecessaryStartQuotes.matcher((CharSequence)code).replaceFirst("");
        code = unnecessaryEndQuotes.matcher((CharSequence)code).replaceFirst("");
        code = unnecessaryMiddleQuotes.matcher((CharSequence)code).replaceAll("");
        return code;
    }

    public String getJavaCode() {
        return this.getJavaCode("clv", this.rawJavaCode);
    }

    public String getJavaCode(String func, String code) {
        StringBuilder sb = new StringBuilder(func).append("(").append(this.replaceQuotes(code)).append(")");
        return sb.toString();
    }

    public void uncryptData(Script script) {
        if (this.dataList != null && this.dataList.length > 0) {
            this.calculated = "";
            for (Object obj : this.dataList) {
                this.calculated = obj instanceof Password ? this.calculated + ((Password)obj).getValue() : this.calculated + obj.toString();
            }
        }
    }

    public void uncrypt(Script script) {
        if (this.calculated != null) {
            Matcher mv = PASSWORD_PATTERN.matcher(this.getCalculated());
            while (mv.find()) {
                this.crypted = true;
                this.safeCalculated = this.calculated.replace(mv.group(0), CRYPTED_DATA_SHOW);
                this.calculated = this.calculated.replace(mv.group(0), script.getPassword(mv.group(1)));
            }
        }
    }

    public String uncrypt(ActionTestScript script, String value) {
        Matcher mv = PASSWORD_PATTERN.matcher(value);
        while (mv.find()) {
            this.crypted = true;
            this.safeCalculated = value.replace(mv.group(0), CRYPTED_DATA_SHOW);
            value = value.replace(mv.group(0), script.getPassword(mv.group(1)));
        }
        return value;
    }

    private void addTextChain(boolean oneChar, ActionTestScript script, ArrayList<SendKeyData> list, String value) {
        String unCrypted = this.uncrypt(script, value);
        if (oneChar) {
            for (int i = 0; i < unCrypted.length(); ++i) {
                list.add(new SendKeyData(String.valueOf(unCrypted.charAt(i))));
            }
        } else {
            list.add(new SendKeyData(unCrypted));
        }
    }

    public ArrayList<SendKeyData> getCalculatedText(ActionTestScript script, boolean oneChar) {
        ArrayList<SendKeyData> chainKeys = new ArrayList<SendKeyData>();
        String calc = this.getCalculated();
        int start = 0;
        Matcher match = KEY_REGEXP.matcher(calc);
        while (match.find()) {
            int end = match.start();
            if (end > 0) {
                this.addTextChain(oneChar, script, chainKeys, calc.substring(start, end));
            }
            start = match.end();
            chainKeys.add(new SendKeyData(match.group(1), match.group(2).replace("-", "")));
        }
        if (start == 0) {
            this.addTextChain(oneChar, script, chainKeys, calc);
        } else if (start != calc.length()) {
            this.addTextChain(oneChar, script, chainKeys, calc.substring(start));
        }
        return chainKeys;
    }

    public String getDataListItem() {
        if (this.dataList != null && this.dataList.length > 0) {
            return this.dataList[0].toString();
        }
        return this.calculated;
    }

    public String getKeywords() {
        return this.data;
    }

    public String getSafeCalculated() {
        if (this.safeCalculated != null) {
            return this.safeCalculated;
        }
        return this.getCalculated();
    }

    public String getCalculated() {
        if (this.calculated == null) {
            if (this.dataList != null) {
                StringBuilder builder = new StringBuilder("");
                for (Object obj : this.dataList) {
                    if (obj instanceof Variable) {
                        builder.append(((Variable)obj).getCalculatedValue());
                        continue;
                    }
                    if (obj == null) continue;
                    builder.append(Channel.checkSystemValue(obj));
                }
                return builder.toString();
            }
            return this.data;
        }
        return this.calculated;
    }

    public int getCalculatedInteger() {
        return Utils.string2Int(this.getCalculated());
    }

    public void setCalculated(String value) {
        this.calculated = value;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String value) {
        if (value == null) {
            value = "";
        }
        this.data = value;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }
}

