/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.channels.Channel;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.ActionWindow;
import com.ats.script.actions.IActionStoppable;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.tools.logger.ExecutionLogger;
import com.google.gson.JsonObject;
import java.util.function.Predicate;

public class ActionWindowSwitch
extends ActionWindow
implements IActionStoppable {
    public static final String SCRIPT_SWITCH_LABEL = "window-switch";
    public static final Predicate<String> PREDICATE = g -> g.startsWith(SCRIPT_SWITCH_LABEL);
    public static final String SWITCH_INDEX = "index";
    public static final String SWITCH_NAME = "name";
    public static final String SWITCH_URL = "url";
    private CalculatedValue value = new CalculatedValue(0);
    private int tries = 0;
    private int delay = 0;
    private boolean refresh = false;
    private String type = "index";
    private boolean regexp;

    public ActionWindowSwitch() {
    }

    public ActionWindowSwitch(Script script, ExecuteOptions options, CalculatedValue value, String type, boolean regexp) {
        super(script, options);
        this.setType(type);
        this.setValue(value);
        this.setRegexp(regexp);
        this.setTries(options.getTryAndDelay().getMaxTry());
        this.setDelay(options.getTryAndDelay().getDelay());
        this.setRefresh(options.hasRefresh());
    }

    public ActionWindowSwitch(Script script, ExecuteOptions options, CalculatedValue value, String type, boolean regexp, int tries, int delay, boolean refresh) {
        super(script, options);
        this.setValue(value);
        this.setType(type);
        this.setRegexp(regexp);
        this.setTries(tries);
        this.setDelay(delay);
        this.setRefresh(refresh);
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append(this.value.getJavaCode()).append(", ").append("\"").append(this.type).append("\", ").append(this.regexp).append(", ").append(this.tries).append(", ").append(this.delay).append(", ").append(this.refresh).append(")");
    }

    @Override
    public String exec(Channel channel, ExecutionLogger logger) {
        channel.switchWindow(this.status, this.type, this.regexp, this.value, this.tries, this.delay, this.refresh);
        return this.value.getCalculated();
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty(this.type, this.value.getCalculated());
        data.addProperty("tries", (Number)this.tries);
        data.addProperty("refresh", Boolean.valueOf(this.refresh));
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public boolean isStop() {
        return true;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public CalculatedValue getValue() {
        return this.value;
    }

    public void setValue(CalculatedValue value) {
        this.value = value;
    }

    public int getTries() {
        return this.tries;
    }

    public void setTries(int tries) {
        this.tries = tries;
    }

    public static StringBuilder getAtsCodeStr() {
        return new StringBuilder().append("window-").append(" -> ");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        value = SWITCH_INDEX.equalsIgnoreCase(value) || SWITCH_NAME.equalsIgnoreCase(value) || SWITCH_URL.equalsIgnoreCase(value) ? value.toLowerCase() : SWITCH_INDEX;
        this.type = value;
    }

    public boolean isRegexp() {
        return this.regexp;
    }

    public void setRegexp(boolean value) {
        this.regexp = value;
    }
}

