/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

import com.ats.tools.RegexpTimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpressionUtils {
    private static final int checkInterval = 3000000;

    public static Matcher createMatcherWithTimeout(String stringToMatch, Pattern regularExpressionPattern, long timeout) {
        if (stringToMatch == null) {
            throw new RegexpTimeoutException("String data to match is null !");
        }
        if (timeout <= 0L) {
            return regularExpressionPattern.matcher(stringToMatch);
        }
        return regularExpressionPattern.matcher(new TimeoutRegexCharSequence(stringToMatch, timeout * 1000L, stringToMatch, regularExpressionPattern.pattern(), 3000000));
    }

    private static class TimeoutRegexCharSequence
    implements CharSequence {
        private final CharSequence inner;
        private final long timeoutMillis;
        private final long timeoutTime;
        private final String stringToMatch;
        private final String regularExpression;
        private int checkInterval;
        private int attemps;

        TimeoutRegexCharSequence(CharSequence inner, long timeoutMillis, String stringToMatch, String regularExpression, int checkInterval) {
            this.inner = inner;
            this.timeoutMillis = timeoutMillis;
            this.stringToMatch = stringToMatch;
            this.regularExpression = regularExpression;
            this.timeoutTime = System.currentTimeMillis() + timeoutMillis;
            this.checkInterval = checkInterval;
            this.attemps = 0;
        }

        @Override
        public char charAt(int index) {
            if (this.attemps == this.checkInterval) {
                if (System.currentTimeMillis() > this.timeoutTime) {
                    throw new RegexpTimeoutException(this.regularExpression, this.stringToMatch, this.timeoutMillis);
                }
                this.attemps = 0;
            } else {
                ++this.attemps;
            }
            return this.inner.charAt(index);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new TimeoutRegexCharSequence(this.inner.subSequence(start, end), this.timeoutMillis, this.stringToMatch, this.regularExpression, this.checkInterval);
        }

        @Override
        public String toString() {
            return this.inner.toString();
        }
    }
}

