/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.context.reader;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.adapters.ReportAdapter;
import com.ats.tools.report.context.reader.ReportContextExecutionReader;
import com.ats.tools.report.filters.ContentFilter;
import com.ats.tools.report.filters.ContentFilterFactory;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Properties;
import com.ats.tools.report.models.ReportContextExecution;
import com.ats.tools.report.models.ReportFileNames;
import com.ats.tools.report.models.ReportItem;
import com.ats.tools.report.models.ReportSettings;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.SuiteInfo;
import com.ats.tools.report.models.TestSummary;
import com.ats.tools.report.summary.SummaryCalculator;
import com.ats.tools.report.utils.TimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractReportContextExecutionReader
implements ReportContextExecutionReader {
    private List<Script> scripts;
    private HtmlReportProject project;
    private Results results;
    private List<TestSummary> testSummaries;
    private final ReportAdapter reportAdapter;
    private final SummaryCalculator summaryCalculator;
    private final ReportSettings reportSettings;
    private final ReportItem suiteItem;

    protected AbstractReportContextExecutionReader(ReportAdapter reportAdapter, SummaryCalculator summaryCalculator, ReportSettings reportSettings, ReportItem suiteItem) {
        this.reportAdapter = reportAdapter;
        this.summaryCalculator = summaryCalculator;
        this.reportSettings = reportSettings;
        this.suiteItem = suiteItem;
    }

    @Override
    public ReportContextExecution getReportContextExecution() throws Exception {
        this.readFiles();
        this.reportAdapter.apply(this.testSummaries, this.results, this.scripts);
        List<SuiteInfo> suiteInfos = this.getSuiteInfos(this.results);
        this.populateSuiteInfo(this.project, suiteInfos);
        this.populateScriptAndSummary(this.scripts, this.testSummaries, suiteInfos);
        this.project.getSuites().forEach(suite -> suite.setSuiteSummary(this.summaryCalculator.calculateSuiteSummary(suite.getSuiteInfo(), this.scripts)));
        this.project.setReportSummary(this.summaryCalculator.calculateReportSummary(this.results, this.project.getSuites(), this.testSummaries));
        this.project.setResults(this.results);
        this.project.setProperties(this.readProjectProperties());
        ContentFilter contentFilter = this.getContentFilter();
        return new ReportContextExecution(this.project, this.suiteItem, this.reportSettings, this.buildReportFileName(this.reportSettings.concatenationRun()), contentFilter);
    }

    abstract void readFiles() throws Exception;

    abstract Properties readProjectProperties() throws Exception;

    protected ContentFilter getContentFilter() {
        return this.reportSettings.hideDurations() ? ContentFilterFactory.getHideDurationFilter() : ContentFilterFactory.getNoHideDurationFilter();
    }

    protected TestSummary readTestSummary(File summaryPath, String suiteName, String testName) throws Exception {
        XMLEventReader eventReader = null;
        TestSummary summary = new TestSummary();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            eventReader = factory.createXMLEventReader(new FileInputStream(summaryPath));
            boolean summaryAdded = false;
            while (eventReader.hasNext() && !summaryAdded) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement startElement = event.asStartElement();
                String elementName = startElement.getName().getLocalPart();
                if ("summary".equals(elementName)) {
                    Attribute actionsAttr = startElement.getAttributeByName(new QName("actions"));
                    Attribute durationAttr = startElement.getAttributeByName(new QName("duration"));
                    Attribute statusAttr = startElement.getAttributeByName(new QName("status"));
                    summary.setActions(actionsAttr != null ? actionsAttr.getValue() : "");
                    summary.setDuration(durationAttr != null ? durationAttr.getValue() : "");
                    summary.setStatus(statusAttr != null ? statusAttr.getValue() : "");
                    summary.setSuiteName(suiteName);
                    summary.setTestName(testName);
                    String executionTime = Optional.ofNullable(summary.getDuration()).filter(StringUtils::isNotBlank).map(Long::parseLong).map(TimeUtil::roundUpToSecond).map(Object::toString).orElse(Long.toString(1000L));
                    summary.setExecutionTime(executionTime);
                    summaryAdded = true;
                    continue;
                }
                if (!"started".equals(elementName)) continue;
                summary.setStarted(Long.parseLong(eventReader.getElementText()));
            }
        }
        catch (Exception e) {
            throw new Exception(String.format("Exception readding test summary for %s#%s", suiteName, testName), e);
        }
        finally {
            if (Objects.nonNull(eventReader)) {
                eventReader.close();
            }
        }
        return summary;
    }

    private void populateSuiteInfo(HtmlReportProject project, List<SuiteInfo> suiteInfos) {
        Map<String, List> nameToSuiteInfoMapping = suiteInfos.stream().collect(Collectors.groupingBy(SuiteInfo::getName, Collectors.collectingAndThen(Collectors.toList(), suites -> {
            suites.sort((o1, o2) -> Long.compare(o2.getStarted(), o1.getStarted()));
            return suites;
        })));
        project.getSuites().forEach(suite -> Optional.ofNullable((List)nameToSuiteInfoMapping.get(suite.getName())).filter(CollectionUtils::isNotEmpty).ifPresent(suiteInfo -> suite.setSuiteInfo((SuiteInfo)suiteInfo.getFirst())));
    }

    private void populateScriptAndSummary(List<Script> scripts, List<TestSummary> testSummaries, List<SuiteInfo> suiteInfos) {
        Map<String, List<Script>> scriptsBySuites = scripts.stream().collect(Collectors.groupingBy(Script::getSuite));
        Map<String, List> summariesBySuites = testSummaries.stream().collect(Collectors.groupingBy(TestSummary::getSuiteName, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparingLong(TestSummary::getStarted)).toList())));
        suiteInfos.forEach(suiteInfo -> {
            List suiteScripts = Optional.ofNullable((List)scriptsBySuites.get(suiteInfo.getName())).orElseThrow(() -> new IllegalStateException(String.format("no scripts presented for %s suite", suiteInfo.getName())));
            List suiteSummaries = Optional.ofNullable((List)summariesBySuites.get(suiteInfo.getName())).orElseThrow(() -> new IllegalStateException(String.format("no summaries presented for %s suite", suiteInfo.getName())));
            if (suiteScripts.size() != suiteSummaries.size()) {
                throw new IllegalStateException(String.format("suite %s: scripts - %d; summaries: %d", suiteInfo.getName(), suiteScripts.size(), suiteSummaries.size()));
            }
            suiteInfo.setScripts(suiteScripts);
            suiteInfo.setSummaries(suiteSummaries);
        });
    }

    private List<SuiteInfo> getSuiteInfos(Results results) {
        try {
            Map collect = results.getSuites().stream().collect(Collectors.toMap(SuiteInfo::getName, Function.identity()));
            return new ArrayList<SuiteInfo>(collect.values());
        }
        catch (IllegalStateException e) {
            AtsLogger.printLog("\n------------------------------------------------------------------------------------------------------------\nWARNING: ats-results.json file has suites duplication. Clear test output folder and run tests again, please.\n------------------------------------------------------------------------------------------------------------\n");
            throw e;
        }
    }

    protected ReportFileNames buildReportFileName(boolean concatenationRun) {
        if (concatenationRun) {
            return new ReportFileNames("ats-report-concat.html", "validation-report-concat.html", "summary-concat.html", "ats-report-concat.xml");
        }
        return new ReportFileNames("ats-report.html", "validation-report.html", "summary.html", "ats-report.xml");
    }

    public List<Script> getScripts() {
        return this.scripts;
    }

    protected void setScripts(List<Script> scripts) {
        this.scripts = scripts;
    }

    public HtmlReportProject getProject() {
        return this.project;
    }

    protected void setProject(HtmlReportProject project) {
        this.project = project;
    }

    public Results getResults() {
        return this.results;
    }

    protected void setResults(Results results) {
        this.results = results;
    }

    public List<TestSummary> getTestSummaries() {
        return this.testSummaries;
    }

    protected void setTestSummaries(List<TestSummary> testSummaries) {
        this.testSummaries = testSummaries;
    }

    public ReportSettings getReportSettings() {
        return this.reportSettings;
    }
}

