/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.generators;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.context.reader.ConcatenatorReportContextExecutionReader;
import com.ats.tools.report.generators.CampaignReportGenerator;
import com.ats.tools.report.models.ConcatenatorCommandLineArguments;
import com.ats.tools.report.models.ReportItem;
import com.ats.tools.report.models.ReportSettings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CampaignReportConcatenatorGenerator {
    private final Options options;
    private final Option output = Option.builder((String)"output").longOpt("output").hasArg().required().desc("output folder, it must exist.").build();
    private final Option concatReportFolders = Option.builder((String)"concat-report-folders").longOpt("concat-report-folders").hasArg().required().desc("comma-separated list of absolute execution folder paths").build();
    private final Option atsReport = Option.builder((String)"ats-report").longOpt("ats-report").hasArg().required(false).desc("specify the level of reporting of the developer (0 : disabled, 1 : standard, 2 : detailed report, 3 : detailed report with screenshots)").build();
    private final Option validationReport = Option.builder((String)"validation-report").longOpt("validation-report").hasArg().required(false).desc("activation parameter for the validation report (0 : disabled, 1 : enabled)").build();
    private final String[] args;

    public CampaignReportConcatenatorGenerator(String[] args) {
        this.args = args;
        this.options = new Options();
        this.options.addOption(this.output);
        this.options.addOption(this.concatReportFolders);
        this.options.addOption(this.atsReport);
        this.options.addOption(this.validationReport);
    }

    public static void main(String[] args) {
        long startTime = System.nanoTime();
        new AtsLogger(System.out, "", "INFO", Paths.get("", new String[0]));
        CampaignReportConcatenatorGenerator.printLog("Reports generation start");
        CampaignReportConcatenatorGenerator generator = new CampaignReportConcatenatorGenerator(args);
        try {
            generator.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CampaignReportConcatenatorGenerator.printLog("Reports generation finish");
        Duration generationDuration = Duration.ofNanos(System.nanoTime() - startTime);
        CampaignReportConcatenatorGenerator.printLog(String.format("Reports generated in %d second(s) %d millisecond(s)", generationDuration.toSeconds(), generationDuration.toMillisPart()));
    }

    public void generate() throws Exception {
        ConcatenatorCommandLineArguments arguments;
        try {
            arguments = this.parseArg();
        }
        catch (IllegalArgumentException | ParseException e) {
            CampaignReportConcatenatorGenerator.printError(e.getMessage());
            return;
        }
        CampaignReportConcatenatorGenerator.printLog(String.format("Input params: %s", arguments));
        ReportSettings reportSettings = new ReportSettings(arguments.output(), arguments.output().resolve("ats-suites.json"), arguments.atsReport(), arguments.validationReport() == 1, false, false, true);
        ReportItem suiteItem = new ReportItem(CampaignReportConcatenatorGenerator.class.getName(), false);
        ConcatenatorReportContextExecutionReader reader = new ConcatenatorReportContextExecutionReader(arguments.concatReportFolders(), reportSettings, suiteItem);
        new CampaignReportGenerator(reader).generateSuitsHtmlReports();
    }

    protected ConcatenatorCommandLineArguments parseArg() throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(this.options, this.args);
        String outputValue = line.getOptionValue(this.output);
        String concatReportFoldersValue = line.getOptionValue(this.concatReportFolders);
        String atsReportValue = line.getOptionValue(this.atsReport, "3");
        String validationReportValue = line.getOptionValue(this.validationReport, "0");
        this.validateArguments(outputValue, concatReportFoldersValue, atsReportValue, validationReportValue);
        List<Path> concatReportFolders = Stream.of(concatReportFoldersValue.split(",")).map(x$0 -> Paths.get(x$0, new String[0])).toList();
        return new ConcatenatorCommandLineArguments(Paths.get(outputValue, new String[0]), concatReportFolders, Integer.parseInt(atsReportValue), Integer.parseInt(validationReportValue));
    }

    private void validateArguments(String output, String reportFolders, String atsReport, String validationReport) {
        int validationReportValue;
        int atsReportValue;
        String[] splitReportFolders;
        Path outputPath = Paths.get(output, new String[0]);
        if (!Files.exists(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException("output folder does not exist");
        }
        for (String folder : splitReportFolders = reportFolders.split(",")) {
            String xmlFolder = String.format("%s_xml", folder);
            Path realFolder = outputPath.resolve(Paths.get(xmlFolder, new String[0]));
            Path actionXmlFile = realFolder.resolve("actions.xml");
            if (!Files.exists(realFolder, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("%s folder does not exists for test %s", xmlFolder, folder));
            }
            if (Files.exists(actionXmlFile, new LinkOption[0])) continue;
            throw new IllegalArgumentException(String.format("%s file does not exists in %s folder for test %s", "actions.xml", xmlFolder, folder));
        }
        try {
            atsReportValue = Integer.parseInt(atsReport);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Unable to parse value %s for ats-report parameter", atsReport));
        }
        if (atsReportValue < 0 || atsReportValue > 3) {
            throw new IllegalArgumentException(String.format("Invalid value %s for ats-report param", atsReport));
        }
        try {
            validationReportValue = Integer.parseInt(validationReport);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Unable to parse value %s for validation-report parameter", validationReport));
        }
        if (validationReportValue != 0 && validationReportValue != 1) {
            throw new IllegalArgumentException(String.format("Invalid value %s for validation-report parameter", validationReport));
        }
    }

    private static void printLog(String data) {
        AtsLogger.printLog(data);
    }

    private static void printError(String data) {
        AtsLogger.printLog("ERROR: " + data);
    }
}

