/*
 * Decompiled with CFR 0.152.
 */
package com.ats.crypto;

import com.ats.AtsSingleton;
import com.ats.crypto.PasswordData;
import com.ats.script.Project;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Passwords
implements Serializable {
    private static final long serialVersionUID = -2364261599407176796L;
    private static final String OLD_NAME = "passwords.crypto";
    private transient File file;
    private int keyLen = 16;
    private byte[] masterKey;
    private HashMap<String, byte[]> data = new HashMap();

    public Passwords() {
        try {
            byte[] data = Project.getSecretFileContent();
            if (data != null) {
                this.load(Base64.getDecoder().decode(data));
            }
        }
        catch (IOException e) {
            Passwords.sendAtsLogsError(e.getMessage());
        }
    }

    public Passwords(Path assetsPath) {
        this.file = Passwords.checkFile(assetsPath);
        if (this.file.exists()) {
            this.load();
        } else {
            this.save();
        }
    }

    public Passwords(File assetsFolder) {
        try {
            this.file = Passwords.checkFile(assetsFolder.toPath());
            if (this.file.exists()) {
                this.load();
            } else {
                this.file = null;
            }
        }
        catch (Exception e) {
            this.file = null;
        }
    }

    private static File checkFile(Path assetsPath) {
        Path secretFolder = assetsPath.resolve("secret");
        File f = secretFolder.resolve("pdata").toFile();
        if (f.exists()) {
            return f;
        }
        f = secretFolder.resolve(OLD_NAME).toFile();
        if (f.exists()) {
            try {
                Path newFilePath = secretFolder.resolve("pdata");
                Files.move(f.toPath(), newFilePath, new CopyOption[0]);
                return newFilePath.toFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return secretFolder.resolve("pdata").toFile();
    }

    public void setPassword(String key, String value) {
        this.data.put(key, value.getBytes());
        this.save();
        this.load();
    }

    public String getPassword(String key) {
        if (this.data.containsKey(key)) {
            return new String(this.data.get(key)).replaceAll("\u0000", "");
        }
        return "";
    }

    public PasswordData[] getDataList() {
        List keySet = this.data.keySet().stream().collect(Collectors.toList());
        Collections.sort(keySet, (o1, o2) -> o1.compareTo((String)o2));
        PasswordData[] result = new PasswordData[this.data.size()];
        int loop = 0;
        for (String key : keySet) {
            result[loop] = new PasswordData(key, this.getPassword(key));
            ++loop;
        }
        return result;
    }

    public void clear() {
        this.data.clear();
    }

    private String getAtsKey() {
        String key = AtsSingleton.getInstance().getAtsKey();
        if (key != null) {
            return key;
        }
        Project p = Project.getProjectData(this.file, null, null);
        return p.getAtsKey();
    }

    private byte[] loadFileBytes() throws IOException {
        byte[] bytes = Base64.getDecoder().decode(Files.readAllBytes(this.file.toPath()));
        String atsKey = this.getAtsKey();
        if (atsKey != null) {
            bytes = this.decrypt(atsKey.getBytes(), bytes);
        }
        return bytes;
    }

    private void saveFileBytes(byte[] bytes) throws IOException {
        String atsKey = this.getAtsKey();
        if (atsKey != null) {
            bytes = Passwords.encrypt(atsKey.getBytes(), bytes);
        }
        Files.write(this.file.toPath(), Base64.getEncoder().encode(bytes), new OpenOption[0]);
    }

    private void load() {
        try {
            this.load(this.loadFileBytes());
        }
        catch (IOException e) {
            Passwords.sendAtsLogsError(e.getMessage());
        }
    }

    private void load(byte[] b) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            byte[] key = new byte[this.keyLen];
            bis.read(key, 0, this.keyLen);
            byte[] bytes = this.decrypt(key, bis.readAllBytes());
            bis.close();
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objStream = new ObjectInputStream(byteStream);
            Passwords pass = (Passwords)objStream.readObject();
            this.data = pass.data;
            this.masterKey = pass.masterKey;
        }
        catch (Exception e) {
            Passwords.sendAtsLogsError(e.getMessage());
            return;
        }
        this.data.replaceAll((k, v) -> this.decrypt(this.masterKey, (byte[])v));
    }

    private void save() {
        try {
            this.file.getParentFile().mkdirs();
            byte[] randomKey = new byte[this.keyLen];
            this.masterKey = new byte[this.keyLen];
            SecureRandom random = SecureRandom.getInstanceStrong();
            random.nextBytes(randomKey);
            random.nextBytes(this.masterKey);
            this.data.replaceAll((k, v) -> Passwords.encrypt(this.masterKey, v));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            byte[] dataBytes = Passwords.encrypt(randomKey, bos.toByteArray());
            out.close();
            bos.close();
            bos = new ByteArrayOutputStream();
            bos.write(randomKey);
            bos.write(dataBytes);
            this.saveFileBytes(bos.toByteArray());
            bos.close();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            Passwords.sendAtsLogsError(e.getMessage());
        }
    }

    private static synchronized Cipher getCipher() {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            // empty catch block
        }
        return cipher;
    }

    private static byte[] encrypt(byte[] key, byte[] data) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
            Cipher cipher = Passwords.getCipher();
            cipher.init(1, (Key)skeySpec, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private byte[] decrypt(byte[] key, byte[] data) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
            Cipher cipher = Passwords.getCipher();
            cipher.init(2, (Key)skeySpec, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static void sendAtsLogsError(String message) {
        System.err.println("[ATS-ENCRYPT-EXCEPTION]\n" + message);
    }
}

