/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.AtsSingleton;
import com.ats.driver.ApplicationProperties;
import com.ats.element.FoundElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.ats.executor.drivers.engines.browsers.capabilities.FirefoxOptions;
import com.ats.generator.objects.MouseDirection;
import com.ats.tools.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class FirefoxDriverEngine
extends WebDriverEngine {
    private OkHttpClient client;

    public FirefoxDriverEngine(Channel channel, ActionStatus status, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, boolean enableLearning) {
        super(channel, driverInfo, systemDriver, props, AtsSingleton.getInstance().getVelocity().getFirefoxDefaultWait(), AtsSingleton.getInstance().getVelocity().getFirefoxDefaultPropertyWait(), enableLearning);
        ArrayList<Proxy> ar;
        if ("0.17.0".equals(driverInfo.getDriverVersion())) {
            props.addExcludedOptions("moz:debuggerAddress");
        }
        FirefoxOptions options = new FirefoxOptions(new BrowserArgumentsParser(driverInfo, channel.getArguments(), props, "firefox", this.applicationPath, systemDriver), props, systemDriver, channel.getProxy());
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        URI proxyUri = AtsSingleton.getInstance().getProxy().getPacUri();
        if (proxyUri != null && (ar = new ArrayList<Proxy>(ProxySelector.getDefault().select(proxyUri))) != null && ar.size() > 0) {
            Proxy p = ar.get(0);
            builder = builder.proxy(new Proxy(Proxy.Type.HTTP, p.address()));
        }
        builder = builder.connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).cache(null);
        this.client = builder.build();
        this.launchDriver(status, (MutableCapabilities)options);
    }

    @Override
    protected CharSequence getSequenceData(SendKeyData seq) {
        return seq.getSequenceWeb(false);
    }

    @Override
    protected boolean switchToWindowHandle(String handle) {
        if (super.switchToWindowHandle(handle)) {
            this.actionWait();
            return true;
        }
        return false;
    }

    @Override
    protected void switchToFrame(WebElement we) {
        super.switchToFrame(we);
        this.actionWait();
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
        this.middleClickSimulation(status, position, element);
    }

    @Override
    protected void move(FoundElement element, double offsetX, double offsetY) {
        element.getValue().getTagName();
        element.getValue().getRect();
        JsonArray actionList = new JsonArray();
        actionList.add((JsonElement)this.getMoveAction(this.getElementOrigin(element.getId()), offsetX, offsetY));
        this.executeRequestActions(this.getElementAction(actionList));
    }

    @Override
    protected void click(FoundElement element, double offsetX, double offsetY) {
        this.move(element, offsetX, offsetY);
        this.channel.sleep(30);
        JsonObject origin = this.getElementOrigin(element.getId());
        JsonArray actionList = new JsonArray();
        actionList.add((JsonElement)this.getMouseClickAction(origin, "pointerDown"));
        actionList.add((JsonElement)this.getMouseClickAction(origin, "pointerUp"));
        this.executeRequestActions(this.getElementAction(actionList));
    }

    @Override
    public void doubleClick() {
        JsonArray actionList = new JsonArray();
        actionList.add((JsonElement)this.getMouseClickAction("pointerDown"));
        actionList.add((JsonElement)this.getMouseClickAction("pointerUp"));
        actionList.add((JsonElement)this.getMouseClickAction("pointerDown"));
        actionList.add((JsonElement)this.getMouseClickAction("pointerUp"));
        this.executeRequestActions(this.getElementAction(actionList));
    }

    @Override
    protected void loadUrl(ActionStatus status, String url) {
        JsonObject parameters = new JsonObject();
        parameters.addProperty("url", url);
        this.channel.sleepMiddle();
        for (int maxTry = 5; maxTry > 0; --maxTry) {
            try {
                this.executeRequest(parameters, "url");
                return;
            }
            catch (WebDriverException e) {
                this.channel.sleep(300);
                continue;
            }
        }
    }

    private JsonObject getMouseClickAction(JsonObject origin, String type) {
        JsonObject action = new JsonObject();
        action.addProperty("duration", (Number)20);
        action.addProperty("type", type);
        action.addProperty("button", (Number)0);
        action.add("origin", (JsonElement)origin);
        return action;
    }

    private JsonObject getMouseClickAction(String type) {
        JsonObject action = new JsonObject();
        action.addProperty("duration", (Number)20);
        action.addProperty("type", type);
        action.addProperty("button", (Number)0);
        return action;
    }

    private JsonObject getMoveAction(JsonObject origin, double offsetX, double offsetY) {
        JsonObject action = new JsonObject();
        action.addProperty("duration", (Number)150);
        action.addProperty("x", (Number)((int)offsetX));
        action.addProperty("y", (Number)((int)offsetY));
        action.addProperty("type", "pointerMove");
        action.add("origin", (JsonElement)origin);
        return action;
    }

    private JsonObject getElementOrigin(String elemId) {
        JsonObject origin = new JsonObject();
        origin.addProperty("ELEMENT", elemId);
        origin.addProperty("element-6066-11e4-a52e-4f735466cecf", elemId);
        return origin;
    }

    private JsonObject getElementAction(JsonArray actionList) {
        JsonObject parameters = new JsonObject();
        parameters.addProperty("pointerType", "mouse");
        JsonObject actions = new JsonObject();
        actions.addProperty("id", "default mouse");
        actions.addProperty("type", "pointer");
        actions.add("parameters", (JsonElement)parameters);
        actions.add("actions", (JsonElement)actionList);
        JsonArray chainedAction = new JsonArray();
        chainedAction.add((JsonElement)actions);
        JsonObject postData = new JsonObject();
        postData.add("actions", (JsonElement)chainedAction);
        return postData;
    }

    private void executeRequestActions(JsonObject action) {
        this.executeRequest(action, "actions");
    }

    private void executeRequest(JsonObject action, String type) {
        Request request = new Request.Builder().url(this.getDriverInfo().getDriverSessionUrl().append(type).toString()).addHeader("Content-Type", "application/json").post(RequestBody.Companion.create(action.toString(), Utils.JSON_MEDIA)).build();
        try {
            Response response = this.client.newCall(request).execute();
            response.close();
        }
        catch (IOException e) {
            throw new WebDriverException("Geckodriver hangup issue after mouse move action (try to raise up 'actionWait' value in ATS properties for firefox)");
        }
    }
}

