/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.neoload;

import com.ats.AtsSingleton;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.generator.ATS;
import com.ats.script.Script;
import com.ats.script.actions.Action;
import com.ats.tools.Utils;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ActionNeoload
extends Action {
    public static final String SCRIPT_NEOLOAD_LABEL = "neoload";
    private static final String USER_AGENT = "ATS-Neoload-Recoder/" + ATS.getAtsVersion();
    private OkHttpClient client;
    private String apiUrl;

    public ActionNeoload() {
    }

    public ActionNeoload(Script script) {
        super(script);
    }

    private void initClient() {
        this.client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).cache(null).build();
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        AtsSingleton.getInstance().neoloadAction(this, testName, testLine);
    }

    public void executeRequest(Channel channel, String designApiUrl) {
        this.initClient();
        this.apiUrl = designApiUrl;
        this.status.setPassed(true);
        this.status.setMessage(designApiUrl);
    }

    protected boolean postDesignData(Object data) {
        return this.postData(new Gson().toJson((Object)this.getDesignRequest(data)));
    }

    protected boolean postData(String data) {
        RequestBody body = RequestBody.Companion.create(data, Utils.JSON_MEDIA);
        Request.Builder request = new Request.Builder().url(this.apiUrl).post(body).addHeader("User-Agent", USER_AGENT).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json");
        try {
            Response response = this.client.newCall(request.build()).execute();
            if (response.code() >= 200 && response.code() < 300) {
                this.status.setPassed(true);
            } else {
                this.status.setError(-50, response.message());
            }
            response.close();
        }
        catch (IOException e) {
            this.status.setError(-50, e.getMessage());
        }
        return this.status.isPassed();
    }

    protected DesignRequest getDesignRequest(Object data) {
        return new DesignRequest(this, data);
    }

    protected class DesignRequest {
        public Object d;

        public DesignRequest(ActionNeoload this$0, Object data) {
            this.d = data;
        }
    }
}

