/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.general;

import com.ats.tools.ResourceContent;
import com.ats.tools.report.Constants;
import com.ats.tools.report.filters.ContentFilter;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteSummary;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportPlaylist {
    public static final String PLAYLIST_INFO_ONLY_CSS = "playlist-info-only";
    public static final String PLAYLIST_INFO_DATA_FRAME_WITH_HEADER_CSS = "playlist-info-data-frame-with-header";
    public static final String PLAYLIST_INFO_DATA_FRAME_WITH_HEADER_WIDTH_100_CSS = "playlist-info-data-frame-with-header width-100";
    public static final String GROUP_FILTERS_CSS = "group-filters";
    private final String PLAYLIST_NAME = "${playlistName}";
    private final String PLAYLIST_NAME_URI = "${playlistNameUri}";
    private final String PLAYLIST_TESTS_PASSED = "${playlistTestsPassed}";
    private final String PLAYLIST_TESTS_FAILED = "${playlistTestsFailed}";
    private final String PLAYLIST_TESTS_FILTERED = "${playlistTestsFiltered}";
    private final String PLAYLIST_EXECUTION_TIME_SEC = "${playlistExecutionTimeSec}";
    private final String PLAYLIST_EXECUTION_TIME_MIN = "${playlistExecutionTimeMin}";
    private final String PLAYLIST_EXECUTION_TIME_HRS = "${playlistExecutionTimeHrs}";
    private final String PLAYLIST_DESCRIPTION = "${playlistDescription}";
    private final String PLAYLIST_PARAMETERS = "${playlistParameters}";
    private final String PLAYLIST_GROUPS_INCLUDED = "${playlistGroupsIncluded}";
    private final String PLAYLIST_GROUPS_EXCLUDED = "${playlistGroupsExcluded}";
    private final String PLAYLIST_EXECUTION_DETAILS = "suite-execution-details";
    private final String GROUP_DISPLAY_PLACEHOLDER_NOT_EXECUTE = "${donotexecutedisplayplaceholder}";
    private final String GROUP_DISPLAY_PLACEHOLDER_EXECUTE = "${executedisplayplaceholder}";
    public static final String PLAYLIST_NAME_HTML_TEMPLATE = "<a style='color: white;display: flex;align-items: center;' class='hover-underline' href='ats://${playlistNameUri}' target='_self'><div class='external-link-icon external-link-icon-large'></div><div style='font-weight: 100; color: rgba(194, 200, 209)'>Playlist:&nbsp;</div><div class='playlist-info-name-text'>${playListName}</div></a>";
    public static final String GROUP_NAME_HTML_TEMPLATE = "<a style='text-decoration: none; color: rgba(56, 63, 79, 1); display: flex;' href='ats://${groupUri}' target='_self'><div class='external-link-icon'></div>${groupName}</a>";
    private final String PLAYLIST_PARAMETER_HTML_TEMPLATE = "<div class=\"playlist-parameter\">\n                            <div class=\"pp-title\">${title}</div>\n                            <div class=\"pp-value\">${value}</div>\n                        </div>";
    public static final String GROUP_TEMPLATE = "<div class='item-with-frame hover-underline'>${groupWithUri}</div>";
    private static final String playlistTemplate = ResourceContent.getHtmlReportPlaylistTemplate();
    private final Suite suite;
    private final OutputStream fileWriter;
    private final OutputStream validationFileWriter;
    private final HtmlReportProject project;
    private final boolean isNoSuiteLunch;
    private final boolean isCommandLineExecution;
    private final ContentFilter durationFilter;

    public HtmlReportPlaylist(Suite suite, OutputStream fileWriter, OutputStream validationFileWriter, HtmlReportProject project, boolean noSuiteLaunch, ContentFilter durationFilter) {
        this.suite = suite;
        this.fileWriter = fileWriter;
        this.validationFileWriter = validationFileWriter;
        this.project = project;
        this.isNoSuiteLunch = noSuiteLaunch;
        this.isCommandLineExecution = suite.getName().toLowerCase().contains("command line suite");
        this.durationFilter = durationFilter;
    }

    public void processPlaylistFooter() {
        try {
            byte[] footerBytes = "</div></div></div>".getBytes();
            this.fileWriter.write(footerBytes);
            this.validationFileWriter.write(footerBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processPlaylistData() {
        String scriptsStatus;
        SuiteSummary suiteSummary = this.suite.getSuiteSummary();
        String result = StringUtils.replace((String)playlistTemplate, (String)"${playlistName}", (String)this.suite.getName());
        result = result.replace("${playlistNameUri}", this.buildPlaylistName(this.suite));
        result = result.replace("${playlistTestsPassed}", String.valueOf(suiteSummary.passedTestsCount()));
        result = result.replace("${playlistTestsFailed}", String.valueOf(suiteSummary.failedTestsCount()));
        result = result.replace("${playlistTestsFiltered}", String.valueOf(suiteSummary.filteredTestsCount()));
        String string = scriptsStatus = this.suite.getSuiteInfo().getScripts().stream().anyMatch(script -> !script.isPassed()) ? Constants.Status.FAIL.getValue() : Constants.Status.PASS.getValue();
        if (!(this.isCommandLineExecution || this.suite.getSuiteInfo().getStatus().equals(scriptsStatus) && !suiteSummary.testCountMismatch())) {
            this.suite.setDescription("<div class='inconsistency-warning'><div class='warning-icon'></div><div>Inconsistency in execution results has been found! Please contact support.</div></div>" + this.suite.getDescription());
        }
        if (this.isNoSuiteLunch && this.isCommandLineExecution) {
            result = result.replace("suite-execution-details", "display-none");
            if (!this.suite.getDescription().contains("<div class='inconsistency-warning'><div class='warning-icon'></div><div>Inconsistency in execution results has been found! Please contact support.</div></div>")) {
                result = result.replace(PLAYLIST_INFO_ONLY_CSS, "display-none");
            }
            result = result.replace(GROUP_FILTERS_CSS, "display-none");
            result = result.replace(PLAYLIST_INFO_DATA_FRAME_WITH_HEADER_CSS, PLAYLIST_INFO_DATA_FRAME_WITH_HEADER_WIDTH_100_CSS);
            this.suite.setParameters(this.project.getProperties().parameters());
        }
        Duration suiteExecutionTime = Duration.ofMillis(this.suite.getSuiteSummary().executionTime());
        result = result.replace("${playlistExecutionTimeSec}", suiteExecutionTime.toSecondsPart() + " sec");
        result = result.replace("${playlistExecutionTimeMin}", suiteExecutionTime.toMinutesPart() + " min");
        result = result.replace("${playlistExecutionTimeHrs}", suiteExecutionTime.toHours() + " hr");
        result = result.replace("${playlistDescription}", this.suite.getDescription());
        result = result.replace("${playlistParameters}", this.processParameters(this.suite.getParameters()));
        CharSequence includedGroupsString = this.processGroups(this.suite.getIncludedGroups());
        CharSequence excludedGroupsString = this.processGroups(this.suite.getExcludedGroups());
        result = result.replace("${executedisplayplaceholder}", this.buildDisplayGroupsBlockProperty(includedGroupsString));
        result = result.replace("${donotexecutedisplayplaceholder}", this.buildDisplayGroupsBlockProperty(excludedGroupsString));
        result = result.replace("${playlistGroupsIncluded}", includedGroupsString);
        result = result.replace("${playlistGroupsExcluded}", excludedGroupsString);
        if (this.suite.getSuiteInfo() == null || !Constants.Status.PASS.getValue().equals(this.suite.getSuiteInfo().getStatus())) {
            result = result.replace(Constants.StatusIcons.PASS_TRANSPARENT_ICON, Constants.StatusIcons.FAIL_TRANSPARENT_ICON);
        }
        result = this.durationFilter.filter(result);
        try {
            this.fileWriter.write(result.getBytes());
            this.validationFileWriter.write(result.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CharSequence buildDisplayGroupsBlockProperty(CharSequence groups) {
        return StringUtils.isEmpty((CharSequence)groups) ? "style='display: none;'" : "";
    }

    private CharSequence buildPlaylistName(Suite suite) {
        return this.isNoSuiteLunch && this.isCommandLineExecution ? "Single test execution" : PLAYLIST_NAME_HTML_TEMPLATE.replace("${playlistNameUri}", this.project.getProjectUuid() + "/exec/" + suite.getName()).replace("${playListName}", suite.getName());
    }

    private CharSequence buildGroupWithUri(String group) {
        return GROUP_NAME_HTML_TEMPLATE.replace("${groupUri}", this.project.getProjectUuid() + "/group/" + group).replace("${groupName}", group);
    }

    public void processPlaylistTestInfo(String testInfo) throws IOException {
        String finalTestInfo = testInfo.replace("class='general-report-layout-single'", "class='general-report-layout'");
        this.fileWriter.write(finalTestInfo.getBytes());
        this.validationFileWriter.write(finalTestInfo.getBytes());
    }

    public void processPlaylistTestAction(String testAction, boolean writeAction) throws IOException {
        this.fileWriter.write(testAction.getBytes());
        if (writeAction) {
            this.validationFileWriter.write(testAction.getBytes());
        }
    }

    private CharSequence processGroups(List<String> groups) {
        return groups.stream().map(group -> GROUP_TEMPLATE.replace("${groupWithUri}", this.buildGroupWithUri((String)group))).collect(Collectors.joining());
    }

    private CharSequence processParameters(Map<String, String> parameters) {
        return parameters.entrySet().stream().map(stringStringEntry -> {
            String parametersHtml = "<div class=\"playlist-parameter\">\n                            <div class=\"pp-title\">${title}</div>\n                            <div class=\"pp-value\">${value}</div>\n                        </div>".replace("${title}", (CharSequence)stringStringEntry.getKey());
            parametersHtml = parametersHtml.replace("${value}", (CharSequence)stringStringEntry.getValue());
            return parametersHtml;
        }).collect(Collectors.joining());
    }

    public void processTestCaseFooter() throws IOException {
        this.fileWriter.write("</div></div></div></div></div>".getBytes());
        this.validationFileWriter.write("</div></div></div></div></div>".getBytes());
    }
}

