/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.generators;

import com.ats.generator.ATS;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.ReportSummary;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteSummary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.BooleanUtils;

public class AtsReportXmlGenerator {
    private XMLStreamWriter xmlStreamWriter;
    private OutputStream fileOutputStream;
    private final HtmlReportProject project;
    private final int devReportLevel;
    private final boolean validReportLevel;
    private final Path outputFilePath;

    public AtsReportXmlGenerator(HtmlReportProject project, int devReportLevel, Path outputFolderPath, boolean validReportLevel, String outputFileName) {
        this.project = project;
        this.devReportLevel = devReportLevel;
        this.validReportLevel = validReportLevel;
        this.outputFilePath = outputFolderPath.resolve(outputFileName);
    }

    public void writeProjectInfo() throws XMLStreamException, IOException {
        this.initialize();
        ReportSummary reportSummary = this.project.getReportSummary();
        long testsFailed = reportSummary.failedTestsCount();
        long testsPassed = reportSummary.passedTestsCount();
        String base64LogoProperty = this.project.getLogo();
        int actionsCount = reportSummary.executedActionsCount();
        Results results = this.project.getResults();
        this.xmlStreamWriter.writeStartDocument();
        this.xmlStreamWriter.writeStartElement("ats-report");
        this.xmlStreamWriter.writeAttribute("actions", Integer.toString(actionsCount));
        this.xmlStreamWriter.writeAttribute("atsVersion", ATS.getAtsVersion());
        this.xmlStreamWriter.writeAttribute("devReportLevel", String.valueOf(this.devReportLevel));
        this.xmlStreamWriter.writeAttribute("duration", String.valueOf(results.getDuration()));
        this.xmlStreamWriter.writeAttribute("path", "file:" + String.valueOf(this.outputFilePath));
        this.xmlStreamWriter.writeAttribute("projectDescription", this.project.getProjectDescription());
        this.xmlStreamWriter.writeAttribute("projectId", this.project.getProjectId());
        this.xmlStreamWriter.writeAttribute("projectName", this.project.getProjectName());
        this.xmlStreamWriter.writeAttribute("projectUuid", this.project.getProjectUuid());
        this.xmlStreamWriter.writeAttribute("projectVersion", this.project.getProjectVersion());
        this.xmlStreamWriter.writeAttribute("started", String.valueOf(this.project.getStarted()));
        this.xmlStreamWriter.writeAttribute("startedFormated", this.project.getStartedFormatted());
        this.xmlStreamWriter.writeAttribute("startedFormatedZulu", this.project.getStartedFormattedZulu());
        this.xmlStreamWriter.writeAttribute("suitesCount", String.valueOf(results.getSuitesCount()));
        this.xmlStreamWriter.writeAttribute("suitesPassed", String.valueOf(results.getSuitesPassed()));
        this.xmlStreamWriter.writeAttribute("tests", String.valueOf(testsFailed + testsPassed));
        this.xmlStreamWriter.writeAttribute("testsFailed", String.valueOf(testsFailed));
        this.xmlStreamWriter.writeAttribute("testsPassed", String.valueOf(testsPassed));
        this.xmlStreamWriter.writeAttribute("validReportLevel", String.valueOf(BooleanUtils.toInteger((boolean)this.validReportLevel)));
        this.xmlStreamWriter.writeStartElement("pics");
        this.xmlStreamWriter.writeStartElement("pic");
        this.xmlStreamWriter.writeAttribute("name", "logo");
        this.xmlStreamWriter.writeCharacters(base64LogoProperty);
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeStartElement("pic");
        this.xmlStreamWriter.writeAttribute("name", "true");
        this.xmlStreamWriter.writeCharacters(this.project.getICON_TRUE());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeStartElement("pic");
        this.xmlStreamWriter.writeAttribute("name", "false");
        this.xmlStreamWriter.writeCharacters(this.project.getICON_FALSE());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.flush();
    }

    public void writeSuiteData(Suite suite) {
        SuiteSummary suiteSummary = suite.getSuiteSummary();
        long scriptsPassed = suiteSummary.passedTestsCount();
        long scriptsFailed = suiteSummary.failedTestsCount();
        int suiteActionsCount = suiteSummary.executedActionsCount();
        try {
            this.xmlStreamWriter.writeStartElement("suite");
            this.xmlStreamWriter.writeAttribute("actions", String.valueOf(suiteActionsCount));
            this.xmlStreamWriter.writeAttribute("dateOrder", suite.getDateOrder());
            this.xmlStreamWriter.writeAttribute("description", suite.getDescription());
            this.xmlStreamWriter.writeAttribute("duration", String.valueOf(suite.getSuiteInfo().getDuration()));
            this.xmlStreamWriter.writeAttribute("name", suite.getName());
            this.xmlStreamWriter.writeAttribute("passed", String.valueOf(suite.getSuiteInfo().getStatus().equals("PASS")));
            this.xmlStreamWriter.writeAttribute("started", String.valueOf(suite.getStarted()));
            this.xmlStreamWriter.writeAttribute("startedFormated", suite.getStartedFormatted());
            this.xmlStreamWriter.writeAttribute("startedFormatedZulu", suite.getStartedFormattedZulu());
            this.xmlStreamWriter.writeAttribute("testsCount", String.valueOf(suite.getTests().size()));
            this.xmlStreamWriter.writeAttribute("testsFailed", String.valueOf(scriptsFailed));
            this.xmlStreamWriter.writeAttribute("testsPassed", String.valueOf(scriptsPassed));
            this.xmlStreamWriter.writeStartElement("parameters");
            this.xmlStreamWriter.writeStartElement("parameter");
            this.xmlStreamWriter.writeAttribute("name", "ats-image-quality");
            this.xmlStreamWriter.writeAttribute("value", this.getVisualQualityLabel(suite.getVisualQuality()));
            this.xmlStreamWriter.writeEndElement();
            this.writeSuiteParameters(suite.getParameters());
            this.xmlStreamWriter.writeEndElement();
            this.writeSuiteGroups(suite);
            this.xmlStreamWriter.writeCharacters(" ");
            this.xmlStreamWriter.writeStartElement("tests");
            this.xmlStreamWriter.writeCharacters(" ");
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSuiteGroups(Suite suite) throws XMLStreamException {
        if (!suite.getIncludedGroups().isEmpty() || !suite.getExcludedGroups().isEmpty()) {
            this.xmlStreamWriter.writeStartElement("groups");
            if (!suite.getIncludedGroups().isEmpty()) {
                suite.getIncludedGroups().forEach(includedGroup -> this.writeGroup((String)includedGroup, "included"));
            }
            if (!suite.getExcludedGroups().isEmpty()) {
                suite.getExcludedGroups().forEach(excludedGroup -> this.writeGroup((String)excludedGroup, "excluded"));
            }
            this.xmlStreamWriter.writeEndElement();
        }
    }

    private void writeSuiteParameters(Map<String, String> parameters) {
        parameters.forEach((key, value) -> {
            try {
                this.xmlStreamWriter.writeStartElement("parameter");
                this.xmlStreamWriter.writeAttribute("name", (String)key);
                this.xmlStreamWriter.writeAttribute("value", (String)value);
                this.xmlStreamWriter.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void writeScript(File filePath, int devReportLVL) {
        byte[] buffer = new byte[4096];
        boolean devReportLvlReplaced = false;
        boolean startElementReplaced = false;
        try (FileInputStream fs = new FileInputStream(filePath);){
            int content;
            while ((content = fs.read(buffer)) != -1) {
                byte[] replacement;
                byte[] searchString;
                if (!devReportLvlReplaced) {
                    searchString = "devReportLVL=\"0\"".getBytes();
                    replacement = ("devReportLVL=\"" + devReportLVL + "\"").getBytes();
                    devReportLvlReplaced = this.replaceSpecificString(content, searchString, buffer, replacement);
                }
                if (!(startElementReplaced || (startElementReplaced = this.replaceSpecificString(content, searchString = "<?xml version='1.0' encoding='UTF-8'?>".getBytes(), buffer, replacement = "                                      ".getBytes())) || (startElementReplaced = this.replaceSpecificString(content, searchString = "<?xml version='1.0' encoding='UTF-8' standalone='no'?>".getBytes(), buffer, replacement = "                                                      ".getBytes())))) {
                    searchString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes();
                    replacement = "                                      ".getBytes();
                    startElementReplaced = this.replaceSpecificString(content, searchString, buffer, replacement);
                }
                this.fileOutputStream.write(buffer, 0, content);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean replaceSpecificString(int content, byte[] searchString, byte[] buffer, byte[] replacement) {
        boolean findMatch = false;
        for (int i = 0; i <= content - searchString.length; ++i) {
            boolean match = true;
            for (int j = 0; j < searchString.length; ++j) {
                if (buffer[i + j] == searchString[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            System.arraycopy(replacement, 0, buffer, i, replacement.length);
            i += searchString.length - 1;
            findMatch = true;
        }
        return findMatch;
    }

    private void initialize() throws IOException, XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.fileOutputStream = Files.newOutputStream(this.outputFilePath, new OpenOption[0]);
        this.xmlStreamWriter = outputFactory.createXMLStreamWriter(this.fileOutputStream);
    }

    public void writeFileEnd() throws XMLStreamException, IOException {
        this.xmlStreamWriter.writeEndDocument();
        this.xmlStreamWriter.flush();
        this.xmlStreamWriter.close();
        this.fileOutputStream.close();
    }

    public void writeSuiteEnd() {
        try {
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private String getVisualQualityLabel(int visualQuality) {
        switch (visualQuality) {
            case 1: {
                return "size-optimized";
            }
            case 2: {
                return "speed-optimized";
            }
            case 3: {
                return "quality";
            }
            case 4: {
                return "max-quality";
            }
        }
        return "undefined";
    }

    private void writeGroup(String group, String groupType) {
        try {
            this.xmlStreamWriter.writeStartElement(groupType);
            this.xmlStreamWriter.writeCharacters(group);
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public Path getFilePath() {
        return this.outputFilePath;
    }
}

