/*
 * Decompiled with CFR 0.152.
 */
package com.ats.crypto;

import com.ats.crypto.Passwords;
import com.ats.executor.ActionTestScript;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Password
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ActionTestScript script;
    private transient File file;
    private String name;
    private byte[] data;
    private byte[] key;

    public Password(ActionTestScript script, String name) {
        this.script = script;
        this.name = name;
    }

    public Password(Path p, byte[] b) {
        this.name = p.getFileName().toString().substring(6);
        this.file = p.toFile();
        this.data = b;
    }

    public Password(String name, byte[] key, byte[] b) {
        this.name = name;
        this.data = b;
        this.key = key;
    }

    public String toString() {
        return "$pass(" + this.name + ")";
    }

    public String getValue() {
        return this.script.getPassword(this.name);
    }

    public File getFile() {
        return this.file;
    }

    public byte[] decrypt() {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(this.key, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
            Cipher cipher = Passwords.getCipher();
            cipher.init(2, (Key)skeySpec, ivParameterSpec);
            return cipher.doFinal(this.data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }
}

