/*
 * Decompiled with CFR 0.152.
 */
package com.ats.crypto;

import com.ats.AtsSingleton;
import com.ats.crypto.Password;
import com.ats.crypto.PasswordData;
import com.ats.script.Project;
import com.ats.tools.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Passwords
implements Serializable {
    private static final long serialVersionUID = -2364261599407176796L;
    private static final String DEFAULT_KEY_VALUE = "ats-key-crypto-1";
    private static final String OLD_NAME = "passwords.crypto";
    public static final String PASSWORD_EXTENSION = "atsc";
    private transient Path secretFolder;
    private int keyLen = 16;
    private byte[] masterKey;
    private HashMap<String, byte[]> data = new HashMap();

    public Passwords(ClassLoader cl) {
        try {
            List<Path> urls = Project.getSecretFolderListFiles(cl);
            if (!urls.isEmpty()) {
                byte[] key = this.getAtsKey().getBytes();
                this.data = new HashMap();
                urls.forEach(p -> this.addPasswordToList(key, (Path)p));
                return;
            }
        }
        catch (Exception urls) {
            // empty catch block
        }
        try {
            byte[] data = Project.getSecretFileContent();
            if (data != null) {
                this.load(Base64.getDecoder().decode(data));
            }
        }
        catch (IOException e) {
            Passwords.sendAtsLogsError(e.getMessage());
        }
    }

    public Passwords(Path assetsPath) {
        this.secretFolder = assetsPath.resolve("secret");
        try {
            Files.createDirectories(this.secretFolder, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.checkFiles()) {
            File f = this.checkFile();
            if (f != null) {
                this.load(this.loadFileBytesBase64(f.toPath()));
                this.save();
                f.delete();
            } else {
                this.save();
            }
            this.checkFiles();
        }
    }

    private void addPasswordToList(byte[] key, Path p) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(Files.readAllBytes(p));
            byte[] fileContent = this.decrypt(key, bis.readAllBytes());
            ByteArrayInputStream byteStream = new ByteArrayInputStream(fileContent);
            ObjectInputStream objStream = new ObjectInputStream(byteStream);
            Password pass = (Password)objStream.readObject();
            this.data.put(pass.getName(), pass.decrypt());
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
    }

    private boolean checkFiles() {
        boolean bl;
        block8: {
            byte[] key = this.getAtsKey().getBytes();
            Stream<Path> stream = Files.walk(this.secretFolder, 1, new FileVisitOption[0]);
            try {
                this.data = new HashMap();
                stream.filter(p -> !Files.isDirectory(p, new LinkOption[0]) && PASSWORD_EXTENSION.equals(Utils.getExtension(p))).forEach(p -> this.addPasswordToList(key, (Path)p));
                boolean bl2 = bl = this.data.size() > 0;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    private File checkFile() {
        File singleFile = this.secretFolder.resolve("pdata").toFile();
        if (singleFile.exists()) {
            return singleFile;
        }
        singleFile = this.secretFolder.resolve(OLD_NAME).toFile();
        if (singleFile.exists()) {
            try {
                Path newFilePath = this.secretFolder.resolve("pdata");
                Files.move(singleFile.toPath(), newFilePath, new CopyOption[0]);
                return newFilePath.toFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setPassword(String key, String value) {
        this.data.put(key, value.getBytes());
        this.save();
    }

    public String getPassword(String key) {
        if (this.data.containsKey(key)) {
            return new String(this.data.get(key)).replace("\u0000", "");
        }
        return "";
    }

    public PasswordData[] getDataList() {
        List keySet = this.data.keySet().stream().collect(Collectors.toList());
        Collections.sort(keySet, Comparable::compareTo);
        PasswordData[] result = new PasswordData[this.data.size()];
        int loop = 0;
        for (String key : keySet) {
            result[loop] = new PasswordData(key, this.getPassword(key));
            ++loop;
        }
        return result;
    }

    public void clear() {
        this.data.clear();
    }

    private String getAtsKey() {
        String key = AtsSingleton.getInstance().getAtsKey();
        if (key == null) {
            try {
                Project p = Project.getProjectData(this.secretFolder.toFile(), null, null);
                key = p.getAtsKey();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (key == null) {
            key = DEFAULT_KEY_VALUE;
        }
        return key;
    }

    private byte[] loadFileBytesBase64(Path p) {
        try {
            byte[] bytes = Base64.getDecoder().decode(Files.readAllBytes(p));
            String atsKey = this.getAtsKey();
            if (!DEFAULT_KEY_VALUE.equals(atsKey)) {
                bytes = this.decrypt(atsKey.getBytes(), bytes);
            }
            return bytes;
        }
        catch (IOException e) {
            Passwords.sendAtsLogsError(e.getMessage());
            return null;
        }
    }

    private void load(byte[] b) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            byte[] key = new byte[this.keyLen];
            bis.read(key, 0, this.keyLen);
            byte[] bytes = this.decrypt(key, bis.readAllBytes());
            bis.close();
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objStream = new ObjectInputStream(byteStream);
            Passwords pass = (Passwords)objStream.readObject();
            this.data = pass.data;
            this.masterKey = pass.masterKey;
        }
        catch (Exception e) {
            Passwords.sendAtsLogsError(e.getMessage());
            return;
        }
        this.data.replaceAll((k, v) -> this.decrypt(this.masterKey, (byte[])v));
    }

    private byte[] getMasterKey() {
        if (this.masterKey == null) {
            byte[] randomKey = new byte[this.keyLen];
            this.masterKey = new byte[this.keyLen];
            try {
                SecureRandom random = SecureRandom.getInstanceStrong();
                random.nextBytes(randomKey);
                random.nextBytes(this.masterKey);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return this.masterKey;
    }

    private void save() {
        try (Stream<Path> stream2 = Files.walk(this.secretFolder, 1, new FileVisitOption[0]);){
            stream2.filter(p -> !Files.isDirectory(p, new LinkOption[0]) && PASSWORD_EXTENSION.equals(Utils.getExtension(p))).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException stream2) {
            // empty catch block
        }
        byte[] mkey = this.getMasterKey();
        try {
            byte[] atsKey = this.getAtsKey().getBytes();
            for (Map.Entry<String, byte[]> entry : this.data.entrySet()) {
                Path filePath = this.secretFolder.resolve(entry.getKey() + ".atsc");
                Password pass = new Password(entry.getKey(), mkey, Passwords.encrypt(mkey, entry.getValue()));
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(pass);
                out.close();
                Files.write(filePath, Passwords.encrypt(atsKey, bos.toByteArray()), new OpenOption[0]);
                bos.close();
            }
        }
        catch (IOException e) {
            Passwords.sendAtsLogsError(e.getMessage());
        }
    }

    public void savePassword(String name, String value) {
        Path passwordFile = this.secretFolder.resolve(name + ".atsc");
        if (Files.exists(passwordFile, new LinkOption[0])) {
            try {
                Files.delete(passwordFile);
            }
            catch (IOException e) {
                return;
            }
        }
        byte[] mkey = this.getMasterKey();
        try {
            byte[] atsKey = this.getAtsKey().getBytes();
            Password pass = new Password(name, mkey, Passwords.encrypt(mkey, value.getBytes()));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(pass);
            out.close();
            Files.write(passwordFile, Passwords.encrypt(atsKey, bos.toByteArray()), new OpenOption[0]);
            bos.close();
        }
        catch (IOException e) {
            Passwords.sendAtsLogsError(e.getMessage());
        }
    }

    public static synchronized Cipher getCipher() {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            // empty catch block
        }
        return cipher;
    }

    private static byte[] encrypt(byte[] key, byte[] data) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
            Cipher cipher = Passwords.getCipher();
            cipher.init(1, (Key)skeySpec, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private byte[] decrypt(byte[] key, byte[] data) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
            Cipher cipher = Passwords.getCipher();
            cipher.init(2, (Key)skeySpec, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static void sendAtsLogsError(String message) {
        System.err.println("[ATS-ENCRYPT-EXCEPTION]\n" + message);
    }
}

