/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.element.AtsBaseElement;
import com.ats.element.ParameterElement;
import com.ats.executor.ActionTestScript;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.tools.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import org.openqa.selenium.remote.RemoteWebElement;

public class SearchedElement {
    public static final String WILD_CHAR = "*";
    private static final String DIALOG = "DIALOG";
    private static final String SYSCOMP = "SYSCOMP";
    public static final String IMAGE_TAG = "@IMAGE";
    public static final String RECORD_TAG = "@RECORD";
    public static final String PARAM_ELEMENT = "@PARAM_ELEMENT";
    public static final String INDEX_PROPERTY = "@index";
    public static final String SHADOW_ROOT = "@shadow-root";
    public static final String XPATH_TYPE = "@xpath";
    private String tag = "*";
    private SearchedElement parent;
    private boolean loadAttributes = false;
    private String selector = "";
    private CalculatedValue index;
    private boolean shadowRoot = false;
    private ParameterElement parameterElement;
    private String xpath = null;
    private List<CalculatedProperty> criterias;
    private String[] attributes = new String[0];
    private String[] attributesValues = new String[0];
    private byte[] image;

    public SearchedElement() {
    }

    public SearchedElement(String tag) {
        this.tag = tag;
        this.criterias = new ArrayList<CalculatedProperty>();
    }

    public SearchedElement(ActionTestScript script, String xpath) {
        this.setXpath(xpath);
        this.setIndex(new CalculatedValue(script, "0"));
        this.setCriterias(Collections.emptyList());
    }

    public SearchedElement(Script script, ArrayList<String> elements) {
        String value = elements.remove(0).trim();
        if (XPATH_TYPE.equalsIgnoreCase(value) && !elements.isEmpty()) {
            this.setXpath(elements.getFirst().trim());
            this.setIndex(new CalculatedValue(script, "0"));
            this.setCriterias(Collections.emptyList());
        } else {
            Matcher objectMatcher = Script.OBJECT_PATTERN.matcher(value);
            this.index = new CalculatedValue(script, "0");
            this.setCriterias(new ArrayList<CalculatedProperty>());
            if (objectMatcher.find()) {
                if (objectMatcher.groupCount() >= 1) {
                    this.setTag(objectMatcher.group(1).trim());
                    if (objectMatcher.groupCount() >= 2) {
                        Arrays.stream(objectMatcher.group(2).split(",")).map(String::trim).forEach(s -> this.addCriteria(script, (String)s));
                    }
                } else {
                    this.setTag(value);
                }
            } else {
                this.setTag(value);
            }
            if (!elements.isEmpty()) {
                this.setParent(new SearchedElement(script, elements));
            }
        }
    }

    public SearchedElement(CalculatedValue index, boolean shadow, String tag, CalculatedProperty[] properties) {
        this(null, index, shadow, tag, properties);
    }

    public SearchedElement(SearchedElement parent, CalculatedValue index, boolean shadow, String tag, CalculatedProperty[] properties) {
        this.setParent(parent);
        this.setIndex(index);
        this.setShadowRoot(shadow);
        this.setTag(tag);
        this.setCriterias(Arrays.asList(properties));
    }

    public SearchedElement(SearchedElement parent, CalculatedValue index, boolean shadow, String tag) {
        this(parent, index, shadow, tag, new CalculatedProperty[0]);
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.dispose();
        }
        if (this.criterias != null) {
            while (!this.criterias.isEmpty()) {
                CalculatedProperty prop = this.criterias.remove(0);
                prop.dispose();
            }
        }
    }

    public RemoteWebElement getStartElement(IDriverEngine engine) {
        if (this.parent == null) {
            if (this.parameterElement != null) {
                return this.parameterElement.getRemoteWebElement(engine.getAtsRemoteDriver());
            }
            return null;
        }
        return this.parent.getStartElement(engine);
    }

    private void addCriteria(Script script, String data) {
        if (data.startsWith(INDEX_PROPERTY)) {
            String[] value = data.split("=");
            if (value.length > 1) {
                this.index = new CalculatedValue(script, value[1].trim());
            }
        } else if (SHADOW_ROOT.equals(data)) {
            this.shadowRoot = true;
        } else {
            this.criterias.add(new CalculatedProperty(script, data));
        }
    }

    public int[] updateRecordSelector() {
        int duration = 3;
        int device = 0;
        StringJoiner sb = new StringJoiner(",");
        sb.add(RECORD_TAG);
        for (CalculatedProperty prop : this.getCriterias()) {
            if ("device".equals(prop.getName())) {
                device = Utils.string2Int(prop.getValue().getCalculated());
                sb.add("device=\"" + device + "\"");
                continue;
            }
            if (!"duration".equals(prop.getName())) continue;
            duration = Utils.string2Int(prop.getValue().getCalculated());
            sb.add("duration=\"" + duration + "\"");
        }
        this.selector = sb.toString();
        return new int[]{duration, device};
    }

    public Predicate<AtsBaseElement> getPredicate() {
        StringBuilder sb = new StringBuilder(this.getTag());
        int criteriasCount = this.getCriterias().size();
        this.attributes = new String[criteriasCount];
        this.attributesValues = new String[criteriasCount];
        Predicate<AtsBaseElement> fullPredicate = Objects::nonNull;
        StringJoiner props = new StringJoiner(",");
        for (int i = 0; i < criteriasCount; ++i) {
            CalculatedProperty property = this.getCriterias().get(i);
            String propertyName = property.getName().replace("=", "\\=");
            String propertyValue = property.getValue().getCalculated().replace("=", "\\=");
            props.add(String.format("%s = %s", propertyName, propertyValue).replace(",", "\\,"));
            fullPredicate = property.getPredicate(fullPredicate);
            this.attributes[i] = propertyName;
            this.attributesValues[i] = property.isRegexp() ? propertyName : propertyName + "\t" + propertyValue;
        }
        sb.append(" [").append(props).append("]");
        if (this.getIndex().getCalculatedInteger() != 0) {
            sb.append("[").append(this.getIndex().getCalculatedInteger()).append("]");
        }
        this.selector = sb.toString();
        return fullPredicate;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String[] getAttributesValues() {
        return this.attributesValues;
    }

    public String getAttribute(String key) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i] == null || !this.attributes[i].equalsIgnoreCase(key)) continue;
            return this.attributesValues[i];
        }
        return null;
    }

    public String getSelector() {
        return this.selector;
    }

    public JsonObject toJson() {
        JsonObject data = new JsonObject();
        data.addProperty("tag", this.getTag());
        data.addProperty("shadow", Boolean.valueOf(this.shadowRoot));
        JsonArray dataArray = new JsonArray(this.criterias.size());
        for (CalculatedProperty prop : this.criterias) {
            JsonObject attr = new JsonObject();
            attr.addProperty(prop.getName(), prop.getValue().getCalculated());
            dataArray.add((JsonElement)attr);
        }
        data.add("criterias", new Gson().toJsonTree((Object)dataArray));
        if (this.parent != null) {
            data.add("parent", (JsonElement)this.parent.toJson());
        }
        return data;
    }

    public void setImage(byte[] value) {
        this.image = value;
    }

    public byte[] getImage() {
        CalculatedProperty prop;
        if (this.image == null && (prop = (CalculatedProperty)this.criterias.stream().filter(c -> "source".equals(c.getName())).findFirst().orElse(null)) != null) {
            String imagePath = prop.getValue().getCalculated();
            URL imageUrl = null;
            if (imagePath.startsWith("http://") || imagePath.startsWith("https://") || imagePath.startsWith("file://")) {
                try {
                    imageUrl = new URI(imagePath).toURL();
                }
                catch (MalformedURLException | URISyntaxException exception) {}
            } else {
                String relativePath = "assets/resources/images/" + imagePath;
                imageUrl = this.getClass().getClassLoader().getResource(relativePath);
            }
            if (imageUrl != null) {
                this.image = Utils.loadImage(imageUrl);
            }
        }
        return this.image;
    }

    public boolean isParamElement() {
        return PARAM_ELEMENT.equalsIgnoreCase(this.tag);
    }

    public boolean isImageSearch() {
        return IMAGE_TAG.equalsIgnoreCase(this.tag);
    }

    public boolean isRecordSearch() {
        return RECORD_TAG.equalsIgnoreCase(this.tag);
    }

    public boolean isDialog() {
        return DIALOG.equalsIgnoreCase(this.tag);
    }

    public boolean isScrollable() {
        return this.tag.equals("RecyclerView") || this.tag.equals("Table") || this.tag.equals("CollectionView") || this.tag.equals("WebView");
    }

    public boolean isSysComp() {
        if (this.parent != null) {
            return this.parent.isSysComp();
        }
        return SYSCOMP.equalsIgnoreCase(this.tag);
    }

    public String getJavaCode() {
        StringBuilder codeBuilder = new StringBuilder("el");
        codeBuilder.append("(");
        if (this.xpath != null) {
            codeBuilder.append("\"").append(Utils.escapeJava(this.xpath)).append("\"");
        } else {
            if (this.parent != null) {
                codeBuilder.append(this.parent.getJavaCode());
                codeBuilder.append(", ");
            }
            codeBuilder.append(this.index.getJavaCode());
            codeBuilder.append(", ");
            codeBuilder.append(this.shadowRoot);
            codeBuilder.append(", \"");
            codeBuilder.append(this.getTag());
            if (this.criterias != null && !this.criterias.isEmpty()) {
                codeBuilder.append("\", ");
                StringJoiner joiner = new StringJoiner(", ");
                for (CalculatedProperty criteria : this.criterias) {
                    joiner.add(criteria.getJavaCode());
                }
                codeBuilder.append(joiner);
            } else {
                codeBuilder.append("\"");
            }
        }
        codeBuilder.append(")");
        return codeBuilder.toString();
    }

    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.add(this.tag);
        for (CalculatedProperty crit : this.criterias) {
            keywords.addAll(crit.getKeywords());
        }
        if (this.parent != null) {
            keywords.addAll(this.parent.getKeywords());
        }
        return keywords;
    }

    public String getAtsLearningCode() {
        StringBuilder sb = new StringBuilder(this.getTag().toUpperCase()).append(" [");
        StringJoiner crits = new StringJoiner(", ");
        for (CalculatedProperty prop : this.getCriterias()) {
            crits.add(prop.getAtsLearningCode());
        }
        sb.append(crits).append("]");
        return sb.toString();
    }

    public String getAtsLearning() {
        StringJoiner stack = new StringJoiner(" -> ");
        stack.add(this.getAtsLearningCode());
        SearchedElement p = this.parent;
        while (p != null) {
            stack.add(p.getAtsLearningCode());
            p = p.parent;
        }
        return stack.toString();
    }

    public ParameterElement getParameterElement() {
        return this.parameterElement;
    }

    public void setParameterElement(ParameterElement value) {
        this.parameterElement = value;
    }

    public boolean isShadowRoot() {
        return this.shadowRoot;
    }

    public void setShadowRoot(boolean shadowRoot) {
        this.shadowRoot = shadowRoot;
    }

    public boolean getLoadAttributes() {
        return this.loadAttributes;
    }

    public void setLoadAttributes(boolean value) {
        this.loadAttributes = value;
    }

    public SearchedElement getParent() {
        return this.parent;
    }

    public void setParent(SearchedElement value) {
        this.parent = value;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public CalculatedValue getIndex() {
        return this.index;
    }

    public void setIndex(CalculatedValue value) {
        this.index = value;
    }

    public List<CalculatedProperty> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<CalculatedProperty> value) {
        this.criterias = new ArrayList<CalculatedProperty>(value);
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }
}

