/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.desktop;

import com.ats.element.JsonUtils;
import com.ats.tools.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;

public class AppData {
    private String name;
    private String version;
    private String build;
    private String path;
    private byte[] icon;

    public AppData() {
    }

    public AppData(JsonNode node) {
        this.jsonDeserialize(node);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public byte[] getIcon() {
        if (this.icon == null) {
            return Utils.getWhitePixel();
        }
        return this.icon;
    }

    public void setIcon(byte[] icon) {
        this.icon = icon;
    }

    public void jsonDeserialize(JsonNode node) {
        AppData defaultValue = new AppData();
        if (node instanceof NullNode || node.get("error") != null) {
            return;
        }
        this.setName(JsonUtils.getJsonValue(node, "name", defaultValue.name, String.class));
        this.setVersion(JsonUtils.getJsonValue(node, "version", defaultValue.version, String.class));
        this.setBuild(JsonUtils.getJsonValue(node, "build", defaultValue.build, String.class));
        this.setPath(JsonUtils.getJsonValue(node, "path", defaultValue.path, String.class));
        this.icon = JsonUtils.getBase64Image(node, "icon");
    }
}

