/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.desktop;

import com.ats.element.AtsElement;
import com.ats.element.JsonUtils;
import com.ats.executor.drivers.desktop.AppData;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;

public class DesktopWindow
extends AtsElement {
    private int pid = -1;
    private int handle = -1;
    private AppData app;

    public DesktopWindow() {
    }

    public DesktopWindow(JsonNode node) {
        this.jsonDeserialize(node);
    }

    @JsonGetter(value="pid")
    public int getPid() {
        return this.pid;
    }

    @JsonSetter(value="pid")
    public void setPid(int pid) {
        this.pid = pid;
    }

    @JsonGetter(value="handle")
    public int getHandle() {
        return this.handle;
    }

    @JsonSetter(value="handle")
    public void setHandle(int handle) {
        this.handle = handle;
    }

    @JsonProperty(value="app")
    public AppData getApp() {
        return this.app;
    }

    @JsonProperty(value="app")
    public void setApp(AppData app) {
        this.app = app;
    }

    @JsonGetter(value="appPath")
    public String getAppPath() {
        if (this.app != null) {
            return this.app.getPath();
        }
        return "";
    }

    @JsonGetter(value="appIcon")
    public byte[] getAppIcon() {
        if (this.app != null) {
            return this.app.getIcon();
        }
        return new byte[1];
    }

    @JsonGetter(value="appName")
    public String getAppName() {
        if (this.app != null) {
            return this.app.getName();
        }
        return "";
    }

    @JsonGetter(value="appVersion")
    public String getAppVersion() {
        if (this.app != null) {
            return this.app.getVersion();
        }
        return "";
    }

    @JsonGetter(value="appBuildVersion")
    public String getAppBuildVersion() {
        if (this.app != null) {
            return this.app.getBuild();
        }
        return "";
    }

    public static DesktopWindow createWindow(JsonNode node) {
        DesktopWindow win = new DesktopWindow();
        if (node instanceof NullNode || node.get("error") != null) {
            return win;
        }
        win.setId(node.get("id").asText());
        win.setPid(node.get("pid").asInt(-1));
        win.setHandle(node.get("handle").asInt(-1));
        win.setTag(node.get("tag").asText());
        win.setWidth(node.get("width").asDouble(0.0));
        win.setHeight(node.get("height").asDouble(0.0));
        win.setX(node.get("x").asDouble(0.0));
        win.setY(node.get("y").asDouble(0.0));
        JsonNode obj = node.get("app");
        if (obj != null) {
            ObjectMapper mapper = new ObjectMapper();
            win.setApp((AppData)mapper.convertValue((Object)obj, AppData.class));
        }
        return win;
    }

    @Override
    public void jsonDeserialize(JsonNode node) {
        super.jsonDeserialize(node);
        DesktopWindow defaultValue = new DesktopWindow();
        if (node instanceof NullNode || node.get("error") != null) {
            return;
        }
        this.setPid(JsonUtils.getJsonValue(node, "pid", defaultValue.pid, Integer.class));
        this.setHandle(JsonUtils.getJsonValue(node, "handle", defaultValue.handle, Integer.class));
        JsonNode appData = node.get("app");
        if (appData != null) {
            this.setApp(new AppData(appData));
        }
    }
}

