/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.results;

import com.ats.executor.results.SuiteResult;
import java.util.ArrayList;
import java.util.List;

public class SuiteResultCollection {
    private List<SuiteResult> suites;
    private int suitesPassed = 0;
    private int suitesFailed = 0;
    private int suitesCount = 0;
    private int testsCount = 0;
    private long duration = 0L;
    private long started = System.currentTimeMillis();
    private String status = "PASS";

    public void addSuiteResult(String name, int testsCount, int passed, int failed, int filtered, boolean nativeSuite, long started) {
        if (this.suites == null) {
            this.suites = new ArrayList<SuiteResult>();
        }
        SuiteResult suite = new SuiteResult(name, failed, passed, filtered, nativeSuite, started);
        this.suites.add(suite);
        this.suites.sort((a, b) -> Boolean.compare(a.isNativeSuite(), b.isNativeSuite()));
        if (suite.isPassed()) {
            ++this.suitesPassed;
        } else {
            this.status = "FAIL";
            ++this.suitesFailed;
        }
        ++this.suitesCount;
        this.testsCount += testsCount;
        this.duration += suite.getDuration();
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<SuiteResult> getSuites() {
        return this.suites;
    }

    public void setSuites(List<SuiteResult> suites) {
        this.suites = suites;
    }

    public int getSuitesPassed() {
        return this.suitesPassed;
    }

    public void setSuitesPassed(int suitesPassed) {
        this.suitesPassed = suitesPassed;
    }

    public int getSuitesFailed() {
        return this.suitesFailed;
    }

    public void setSuitesFailed(int suitesFailed) {
        this.suitesFailed = suitesFailed;
    }

    public int getSuitesCount() {
        return this.suitesCount;
    }

    public void setSuitesCount(int suitesCount) {
        this.suitesCount = suitesCount;
    }

    public int getTestsCount() {
        return this.testsCount;
    }

    public void setTestsCount(int testsCount) {
        this.testsCount = testsCount;
    }

    public long getStarted() {
        return this.started;
    }

    public void setStarted(long date) {
        this.started = date;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }
}

