/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.scripts;

import com.ats.driver.AtsRemoteWebDriver;
import com.ats.element.ParameterElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.scripts.AtsCallSubscriptJavascriptException;
import com.ats.executor.scripts.AtsCallSubscriptScript;
import com.ats.script.actions.ActionComment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.testng.annotations.Test;

public class AtsCallSubscriptJavascript
extends AtsCallSubscriptScript {
    private static final String JS_CONSOLE_PREFIX = "ats-js-console: ";
    public static final String JS_LANGUAGE = "js";
    private static final String atsResultPrototype = "function AtsResult(){this.return=null;this.logs=[];this.log=function(s){this.logs.push(s);};this.comments=[];this.comment=function(s){this.comments.push(s);};}const ats_result=new AtsResult();const ats_return=function(data){ats_result.return=data;};const ats_comment=function(data){ats_result.comment(data);};var consoleLogFn=console.log;console.log=function(){consoleLogFn.apply(console,arguments);var args=Array.prototype.slice.call(arguments);for(var i=0;i<args.length;i++){ats_result.log(args[i]);}};\r\n";

    @Test
    public void testMain() {
        long startDuration = System.currentTimeMillis();
        List<Object> resultArray = new ArrayList();
        ActionStatus status = new ActionStatus();
        AtsRemoteWebDriver driver = this.getCurrentChannel().getDriverEngine().getAtsRemoteDriver();
        StringBuilder jsCode = new StringBuilder(atsResultPrototype);
        ParameterElement elem = this.getParameterElement();
        jsCode.append("const ats_parameter=function(i){let ").append((CharSequence)this.getParametersCode()).append(";if(i < p.length){return p[i];}else{return '';}};\r\n");
        if (elem != null) {
            jsCode.append("const ats_element=arguments[0], ").append("ats_iteration").append("=").append(this.getIteration()).append(", ").append("ats_iterations_count").append("=").append(this.getIterationsCount()).append(";\r\n").append(this.code).append(";\r\nreturn ats_result;");
            try {
                resultArray = this.getResultData(driver.executeScript(jsCode.toString(), new Object[]{elem.getRemoteWebElement(driver)}));
            }
            catch (Exception e) {
                throw new AtsCallSubscriptJavascriptException(e.getMessage(), System.currentTimeMillis() - startDuration);
            }
        }
        jsCode.append("const ").append("ats_iteration").append("=").append(this.getIteration()).append(", ").append("ats_iterations_count").append("=").append(this.getIterationsCount()).append(";\r\n").append(this.code).append(";\r\nreturn ats_result;");
        try {
            resultArray = this.getResultData(driver.executeScript(jsCode.toString(), new Object[0]));
        }
        catch (Exception e) {
            throw new AtsCallSubscriptJavascriptException(e.getMessage(), System.currentTimeMillis() - startDuration);
        }
        if (status.getFailMessage() != null) {
            System.out.println(status.getFailMessage());
        }
        this.returnValues(resultArray.toArray());
    }

    private List<String> getResultData(Object obj) {
        if (obj != null && obj instanceof LinkedHashMap) {
            Object ret;
            List comments;
            LinkedHashMap map = (LinkedHashMap)obj;
            List logs = (List)map.get("logs");
            if (logs != null) {
                logs.forEach(l -> System.out.println(JS_CONSOLE_PREFIX + l.toString()));
            }
            if ((comments = (List)map.get("comments")) != null) {
                comments.forEach(l -> this.exec(0, new ActionComment(this, "step", this.clv(l.toString()))));
            }
            if ((ret = map.get("return")) != null) {
                if (ret instanceof ArrayList) {
                    return (List)ret;
                }
                return Arrays.asList(ret.toString());
            }
        } else {
            if (obj instanceof String) {
                return Arrays.asList(obj.toString());
            }
            if (obj instanceof ArrayList) {
                return (List)obj;
            }
        }
        return Collections.emptyList();
    }
}

