/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator;

import com.ats.driver.AtsManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AntCompiler {
    private static final String END_MESSAGE = "ATS project compiled and ready to execute test scripts";

    public static void main(String[] args) throws ParserConfigurationException, Exception {
        if (args.length > 0) {
            String baseDir = ".";
            File buildFile = new File(args[0]);
            if ("build".equals(args[0])) {
                buildFile = Paths.get("build.xml", new String[0]).toAbsolutePath().toFile();
                if (buildFile.exists()) {
                    buildFile.delete();
                }
            } else {
                buildFile = new File(args[0]);
            }
            if (!buildFile.exists()) {
                buildFile.deleteOnExit();
                buildFile.getParentFile().mkdirs();
                FileWriter fw = new FileWriter(buildFile);
                fw.write("<project basedir=\"" + baseDir + "\" default=\"compile\">");
                fw.write("<copy todir=\"${basedir}/target/classes\"> ");
                fw.write("<fileset dir=\"${basedir}/src\" includes='assets/**'/>");
                fw.write("</copy>");
                fw.write("<copy todir=\"${basedir}/target/classes/assets/ats_scripts\"> ");
                fw.write("<fileset dir=\"${basedir}/src/main\" includes='javascript/**'/>");
                fw.write("<fileset dir=\"${basedir}/src/main\" includes='python/**'/>");
                fw.write("<fileset dir=\"${basedir}/src/main\" includes='cs/**'/>");
                fw.write("</copy>");
                fw.write("<property name=\"lib.dir\" value=\"lib\"/>");
                fw.write("<path id=\"classpath\">");
                fw.write("<fileset dir=\"" + AtsManager.getAtsHomeFolder() + "/libs\" includes=\"**/*.jar\"/>");
                fw.write("</path>");
                fw.write("<target name=\"compile\">");
                fw.write("<mkdir dir=\"${basedir}/target/classes\"/>");
                fw.write("<mkdir dir=\"${basedir}/target/generated\"/>");
                fw.write("<copy todir=\"${basedir}/target/generated\"> ");
                fw.write("<fileset dir=\"${basedir}/src/main/java\" includes=\"**\"/>");
                fw.write("</copy>");
                fw.write("<javac srcdir=\"${basedir}/target/generated\" destdir=\"${basedir}/target/classes\" classpathref=\"classpath\" nowarn=\"on\"/>");
                fw.write("<echo message=\"ATS project compiled and ready to execute test scripts\"/>");
                fw.write("</target>");
                fw.write("</project>");
                fw.close();
            }
            AntCompiler.build(buildFile);
        }
    }

    public static File createXmlFile(String targetFolderPath) throws IOException, ParserConfigurationException, TransformerException {
        File tempXml = File.createTempFile("ant_", ".xml");
        tempXml.deleteOnExit();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document writeXmlDocument = builder.newDocument();
        Element project = writeXmlDocument.createElement("project");
        project.setAttribute("basedir", targetFolderPath);
        project.setAttribute("default", "compile");
        Element copy = writeXmlDocument.createElement("copy");
        copy.setAttribute("todir", "classes");
        Element fileset = writeXmlDocument.createElement("fileset");
        fileset.setAttribute("dir", "../src");
        fileset.setAttribute("includes", "assets/**");
        copy.appendChild(fileset);
        project.appendChild(copy);
        Element copy2 = writeXmlDocument.createElement("copy");
        copy2.setAttribute("todir", "classes/assets/ats_scripts");
        Element fileset2 = writeXmlDocument.createElement("fileset");
        fileset2.setAttribute("dir", "../src/main");
        fileset2.setAttribute("includes", "javascript/**");
        Element fileset3 = writeXmlDocument.createElement("fileset");
        fileset3.setAttribute("dir", "../src/main");
        fileset3.setAttribute("includes", "python/**");
        Element fileset4 = writeXmlDocument.createElement("fileset");
        fileset4.setAttribute("dir", "../src/main");
        fileset4.setAttribute("includes", "cs/**");
        copy2.appendChild(fileset2);
        copy2.appendChild(fileset3);
        copy2.appendChild(fileset4);
        project.appendChild(copy2);
        Element target = writeXmlDocument.createElement("target");
        target.setAttribute("name", "compile");
        Element mkdir = writeXmlDocument.createElement("mkdir");
        mkdir.setAttribute("dir", "classes");
        target.appendChild(mkdir);
        mkdir = writeXmlDocument.createElement("mkdir");
        mkdir.setAttribute("dir", "generated");
        target.appendChild(mkdir);
        Element javac = writeXmlDocument.createElement("javac");
        javac.setAttribute("includeantruntime", "true");
        javac.setAttribute("nowarn", "on");
        javac.setAttribute("srcdir", "generated");
        javac.setAttribute("destdir", "classes");
        Element xlint1 = writeXmlDocument.createElement("compilerarg");
        xlint1.setAttribute("value", "-Xlint:none");
        javac.appendChild(xlint1);
        target.appendChild(javac);
        Element echo = writeXmlDocument.createElement("echo");
        echo.setAttribute("message", END_MESSAGE);
        target.appendChild(echo);
        project.appendChild(target);
        writeXmlDocument.appendChild(project);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(writeXmlDocument), new StreamResult(new OutputStreamWriter((OutputStream)new FileOutputStream(tempXml), StandardCharsets.UTF_8)));
        return tempXml;
    }

    public static void build(File buildFile) {
        Project p = new Project();
        p.setUserProperty("ant.file", buildFile.getAbsolutePath());
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        helper.parse(p, (Object)buildFile);
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)consoleLogger);
        try {
            p.executeTarget(p.getDefaultTarget());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

