/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.objects;

import com.ats.tools.Utils;

public enum Cartesian {
    LEFT("left"),
    RIGHT("right"),
    TOP("top"),
    BOTTOM("bottom"),
    MIDDLE("middle"),
    CENTER("center");

    private final String text;

    private Cartesian(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    public boolean isPresent(String value) {
        return value.startsWith(this.text);
    }

    public boolean equals(String value) {
        return this.text.equals(value);
    }

    public String getData(String value) {
        if (Utils.containsIgnoreCase(value, this.text)) {
            String data;
            int found = value.indexOf("=");
            if (found > -1) {
                data = value.substring(found + 1);
            } else {
                found = value.indexOf("(");
                if (found > -1) {
                    data = value.substring(found + 1).replace(")", "");
                } else {
                    return null;
                }
            }
            if (Utils.isAllBlank(data)) {
                return "0";
            }
            return data.trim();
        }
        return null;
    }

    public String getJavacode() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.text.toUpperCase();
    }
}

