/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import java.util.regex.Matcher;
import org.apache.commons.text.StringEscapeUtils;

public class BaseValue {
    protected static final String START_CHAR = "\u00bb";
    protected static final String END_CHAR = "\u00ab";
    protected static final String SEPARATOR = "\u00ac";
    protected String start;
    protected String end;
    protected String value;
    protected String codeValue;
    protected String replace = "";

    public BaseValue(Matcher m) {
        this(m, START_CHAR, END_CHAR);
    }

    public BaseValue(Matcher m, String start, String end) {
        String data;
        this.replace = m.group(0);
        if (this.replace != null) {
            this.replace = StringEscapeUtils.escapeJava((String)this.replace);
        }
        this.value = data = StringEscapeUtils.escapeJava((String)m.group(1));
        this.codeValue = data;
        this.start = start;
        this.end = end;
    }

    public BaseValue(String value) {
        this.value = value;
        this.codeValue = value;
    }

    public String getReplace() {
        return this.replace;
    }

    public String getNoComma() {
        return this.replace.replace(",", "\n");
    }

    public String getCode() {
        StringBuilder codeBuilder = new StringBuilder("(");
        codeBuilder.append(this.codeValue);
        codeBuilder.append(")");
        return codeBuilder.toString();
    }

    public String getType() {
        return "V";
    }

    public String getHashValue() {
        StringBuilder sb = new StringBuilder(this.start);
        sb.append(this.getType()).append(this.value).append(this.end);
        return sb.toString();
    }

    public String replace(String value) {
        return value.replace(this.getReplace(), this.getHashValue());
    }
}

