/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.AtsSingleton;
import com.ats.crypto.Password;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.executor.channels.Channel;
import com.ats.generator.variables.BaseValue;
import com.ats.generator.variables.EnvironmentValue;
import com.ats.generator.variables.KeyParser;
import com.ats.generator.variables.ParameterValue;
import com.ats.generator.variables.ProjectVariableValue;
import com.ats.generator.variables.RandomStringValue;
import com.ats.generator.variables.ScriptVariableValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.transform.DateTransformer;
import com.ats.generator.variables.transform.TimeTransformer;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.tools.Utils;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public class CalculatedValue {
    public static final String CRYPTED_DATA_SHOW = "########";
    private static final Pattern TODAY_PATTERN = Pattern.compile("\\$today", 2);
    private static final Pattern NOW_PATTERN = Pattern.compile("\\$now", 2);
    private static final Pattern UUID_PATTERN = Pattern.compile("\\$uuid", 2);
    private static final Pattern LOOP_PATTERN = Pattern.compile("\\$loop", 2);
    private static final Pattern ITERATION_PATTERN = Pattern.compile("\\$iteration", 2);
    private static final Pattern ITERATIONS_COUNT_PATTERN = Pattern.compile("\\$iterationsCount", 2);
    private static final Pattern LAST_ACTION_DURATION_PATTERN = Pattern.compile("\\$lastActionDuration", 2);
    public static final Pattern ASSET_PATTERN = Pattern.compile("\\$asset\\s*?\\(([^\\)]*)\\)", 2);
    public static final Pattern IMAGE_PATTERN = Pattern.compile("\\$image\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("\\$pass\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern ATS_DATA = Pattern.compile("\\$ats\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern SYS_PATTERN = Pattern.compile("\\$sys\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern PROPERTY_FILE_PATTERN = Pattern.compile("\\$prop\\s*?\\(([^\\)]*) *, *([^\\)]*)\\)", 2);
    private static final Pattern RND_PATTERN = Pattern.compile("\\$rnd(?:string)?\\s*?\\((\\d+),?(\\w{0,3}?[^\\)]*)?\\)", 2);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$var\\s*?\\(([^\\)\\.]*)\\)", 2);
    public static final Pattern PARAMETER_PATTERN = Pattern.compile("\\$param\\(([^)]*)\\)", 2);
    public static final Pattern ENV_PATTERN = Pattern.compile("\\$env\\(([^)]*)\\)", 2);
    private static final Pattern PROJECT_VARIABLE_PATTERN = Pattern.compile("\\$prj\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern GLOBAL_VARIABLE_PATTERN = Pattern.compile("\\$var\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern invalidUnicodePattern = Pattern.compile("[\\p{C}]");
    private static final Pattern unnecessaryStartQuotes = Pattern.compile("^\"\", ?");
    private static final Pattern unnecessaryMiddleQuotes = Pattern.compile(" \"\",");
    private static final Pattern unnecessaryEndQuotes = Pattern.compile(", \"\"$");
    private String calculated;
    private Script script;
    private String data = "";
    private String safeCalculated;
    private String rawJavaCode = "";
    private Object[] dataList;
    private boolean crypted = false;

    public CalculatedValue() {
    }

    public CalculatedValue(String value) {
        this.setData(value);
    }

    public CalculatedValue(int value) {
        this(String.valueOf(value));
    }

    public CalculatedValue(Object[] data) {
        this.dataList = data;
    }

    public CalculatedValue(Script script) {
        this.setScript(script);
        this.setCalculated("");
    }

    public CalculatedValue(Script script, String dataValue) {
        this.setScript(script);
        if (!dataValue.isEmpty()) {
            Matcher matcher = invalidUnicodePattern.matcher(dataValue);
            dataValue = Utils.unescapeAts(matcher.replaceAll(""));
            this.updateData(dataValue);
        }
    }

    public void updateData(String value) {
        this.setData(value);
        this.setCalculated(this.initCalculated(value));
    }

    private String replaceJavaCode(String javaCode, String replace, String code) {
        return javaCode.replace(replace, "\", " + code + ", \"");
    }

    private String initCalculated(String dataValue) {
        String variableName;
        String relativePath;
        String assetExpression;
        StringBuilder sb;
        String value;
        String replace;
        BaseValue v;
        Matcher mv = VARIABLE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            v = new ScriptVariableValue(mv);
            dataValue = v.replace(dataValue);
        }
        mv = PROJECT_VARIABLE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            v = new ProjectVariableValue(mv);
            dataValue = v.replace(dataValue);
        }
        mv = PARAMETER_PATTERN.matcher(dataValue);
        while (mv.find()) {
            v = new ParameterValue(mv);
            dataValue = v.replace(dataValue);
        }
        mv = ENV_PATTERN.matcher(dataValue);
        while (mv.find()) {
            v = new EnvironmentValue(mv);
            dataValue = v.replace(dataValue);
        }
        this.rawJavaCode = dataValue.replace("\\", "\\\\").replace("\"", "\\\"");
        mv = ATS_DATA.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            value = mv.group(1).trim();
            dataValue = dataValue.replace(replace, this.script.getSpecialValue(value));
            StringBuilder sb2 = new StringBuilder("ats").append("(\"").append(value).append("\")");
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, sb2.toString());
        }
        mv = ITERATIONS_COUNT_PATTERN.matcher(dataValue);
        while (mv.find()) {
            dataValue = dataValue.replace(mv.group(0), String.valueOf(this.script.getIterationsCount()));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), "itc()");
        }
        mv = ITERATION_PATTERN.matcher(dataValue);
        while (mv.find()) {
            dataValue = dataValue.replace(mv.group(0), String.valueOf(this.script.getIteration()));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), "itr()");
        }
        mv = LOOP_PATTERN.matcher(dataValue);
        while (mv.find()) {
            dataValue = dataValue.replace(mv.group(0), String.valueOf(this.script.getLoop()));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), "l()");
        }
        mv = PROPERTY_FILE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            String name = mv.group(1);
            String key = mv.group(2);
            dataValue = dataValue.replace(replace, this.script.getPropertyVariableValue(name, key));
            sb = new StringBuilder("ppt").append("(").append("cc").append("(").append(this.replaceQuotes(name)).append("), ").append("cc").append("(\"").append(key).append("\"))");
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, sb.toString());
        }
        mv = PASSWORD_PATTERN.matcher(dataValue);
        while (mv.find()) {
            this.crypted = true;
            StringBuilder sb3 = new StringBuilder("ps").append("(\"").append(mv.group(1)).append("\")");
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, mv.group(0), sb3.toString());
        }
        mv = IMAGE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            assetExpression = mv.group(0);
            relativePath = mv.group(1);
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, assetExpression, Project.getAssetsImageJavaCode(relativePath));
        }
        mv = ASSET_PATTERN.matcher(dataValue);
        while (mv.find()) {
            assetExpression = mv.group(0);
            relativePath = mv.group(1);
            dataValue = dataValue.replace(assetExpression, this.script.getAssetsFilePath(relativePath));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, assetExpression, Project.getAssetsJavaCode(relativePath));
        }
        mv = GLOBAL_VARIABLE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            variableName = mv.group(1);
            dataValue = dataValue.replace(replace, this.script.getGlobalVariableValue(variableName));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "gv(\"" + variableName + "\")");
        }
        mv = SYS_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            value = StringEscapeUtils.escapeJava((String)mv.group(1).trim());
            dataValue = dataValue.replace(replace, AtsSingleton.getInstance().getSystemValue(value));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "sys(\"" + value + "\")");
        }
        mv = TODAY_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, DateTransformer.getTodayValue());
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "td()");
        }
        mv = LAST_ACTION_DURATION_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, String.valueOf(this.script.getLastActionDuration()));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "lad()");
        }
        mv = NOW_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, TimeTransformer.getNowValue());
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "nw()");
        }
        mv = UUID_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, UUID.randomUUID().toString());
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "uid()");
        }
        mv = RND_PATTERN.matcher(dataValue);
        while (mv.find()) {
            RandomStringValue rds = new RandomStringValue(mv);
            dataValue = dataValue.replace(rds.getReplace(), rds.exec());
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, rds.getReplace(), "rds" + rds.getCode());
        }
        mv = ParameterValue.PATTERN.matcher(this.rawJavaCode);
        while (mv.find()) {
            replace = mv.group(0);
            String paramName = mv.group(1);
            String paramDefault = mv.group(2);
            String paramValue = paramName + "\", \"" + paramDefault;
            dataValue = dataValue.replace(replace, this.script.getParameterValue(paramName, paramDefault));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "p(\"" + paramValue + "\")");
        }
        mv = ScriptVariableValue.PATTERN.matcher(this.rawJavaCode);
        while (mv.find()) {
            replace = mv.group(0);
            variableName = mv.group(1);
            dataValue = dataValue.replace(replace, this.script.getVariableValue(variableName));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, variableName);
        }
        mv = ProjectVariableValue.PATTERN.matcher(this.rawJavaCode);
        while (mv.find()) {
            replace = mv.group(0);
            variableName = mv.group(1);
            dataValue = dataValue.replace(replace, this.script.getProjectVariableValue(variableName));
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, "prj(\"" + variableName + "\")");
        }
        mv = EnvironmentValue.PATTERN.matcher(this.rawJavaCode);
        while (mv.find()) {
            replace = mv.group(0);
            String envName = mv.group(1);
            String envDefault = mv.group(2);
            dataValue = dataValue.replace(replace, this.script.getEnvironmentValue(envName, envDefault));
            sb = new StringBuilder("e").append("(").append("cc").append("(").append(this.replaceQuotes(envName)).append("), ").append("cc").append("(\"").append(envDefault).append("\"))");
            this.rawJavaCode = this.replaceJavaCode(this.rawJavaCode, replace, sb.toString());
        }
        this.rawJavaCode = this.cleanCode(this.rawJavaCode);
        return dataValue;
    }

    private String cleanCode(String value) {
        return value.replace(", \"\")", ")").replace("(\"\", ", "(");
    }

    public boolean isCrypted() {
        return this.crypted;
    }

    public void dispose() {
        this.script = null;
        this.dataList = null;
    }

    private String replaceQuotes(String code) {
        code = "\"" + (String)code + "\"";
        code = unnecessaryStartQuotes.matcher((CharSequence)code).replaceFirst("");
        code = unnecessaryEndQuotes.matcher((CharSequence)code).replaceFirst("");
        code = unnecessaryMiddleQuotes.matcher((CharSequence)code).replaceAll("");
        return code;
    }

    public String getJavaCode() {
        return this.getJavaCode("c", this.rawJavaCode);
    }

    public String getJavaCode(String func, String code) {
        StringBuilder sb = new StringBuilder(func).append("(").append(this.replaceQuotes(code)).append(")");
        return sb.toString();
    }

    public void uncryptData() {
        if (this.dataList != null && this.dataList.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (Object obj : this.dataList) {
                if (obj instanceof Password) {
                    Password p = (Password)obj;
                    sb.append(p.getValue());
                    continue;
                }
                sb.append(obj.toString());
            }
            this.calculated = sb.toString();
        }
    }

    public void uncrypt(Script script) {
        if (this.calculated != null) {
            Matcher mv = PASSWORD_PATTERN.matcher(this.getCalculated());
            while (mv.find()) {
                this.crypted = true;
                this.safeCalculated = this.calculated.replace(mv.group(0), CRYPTED_DATA_SHOW);
                this.calculated = this.calculated.replace(mv.group(0), script.getPassword(mv.group(1)));
            }
        }
    }

    public String uncrypt(ActionTestScript script, String value) {
        Matcher mv = PASSWORD_PATTERN.matcher(value);
        while (mv.find()) {
            this.crypted = true;
            this.safeCalculated = value.replace(mv.group(0), CRYPTED_DATA_SHOW);
            value = value.replace(mv.group(0), script.getPassword(mv.group(1)));
        }
        return value;
    }

    public ArrayList<SendKeyData> getCalculatedText(ActionTestScript script, boolean oneChar) {
        return KeyParser.parse(script, oneChar, this);
    }

    public String getDataListItem() {
        if (this.dataList != null && this.dataList.length > 0) {
            return this.dataList[0].toString();
        }
        return this.calculated;
    }

    public String getKeywords() {
        return this.data;
    }

    public String getSafeCalculated() {
        if (this.safeCalculated != null) {
            return this.safeCalculated;
        }
        return this.getCalculated();
    }

    public String getCalculated() {
        if (this.calculated == null) {
            if (this.dataList != null) {
                StringBuilder builder = new StringBuilder("");
                for (Object obj : this.dataList) {
                    if (obj instanceof Variable) {
                        Variable v = (Variable)obj;
                        builder.append(v.getCalculatedValue());
                        continue;
                    }
                    if (obj == null) continue;
                    builder.append(Channel.checkSystemValue(obj));
                }
                return builder.toString();
            }
            return this.data;
        }
        return this.calculated;
    }

    public int getCalculatedInteger() {
        return Utils.string2Int(this.getCalculated());
    }

    public void setCalculated(String value) {
        this.calculated = value;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String value) {
        if (value == null) {
            value = "";
        }
        this.data = value;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }
}

