/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.tools.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableSplit {
    private static final Pattern TR_REGEXP = Pattern.compile("TR(.)", 2);
    private static final Pattern TD_REGEXP = Pattern.compile("TD(.)", 2);
    private String rowSeparator;
    private String columnSeparator;
    private CalculatedValue value;

    public TableSplit() {
    }

    public TableSplit(String row, String col, CalculatedValue value) {
        this.rowSeparator = row;
        this.columnSeparator = col;
        this.value = value;
    }

    public TableSplit(String value) {
        value = Utils.unescapeAts(value);
        if (!value.isEmpty()) {
            Matcher match = TR_REGEXP.matcher(value);
            if (match.find()) {
                this.rowSeparator = match.group(1);
            }
            if ((match = TD_REGEXP.matcher(value)).find()) {
                this.columnSeparator = match.group(1);
            }
        }
    }

    public TableSplit(String optionValue, ParameterList parameters) {
        this(optionValue);
        this.value = parameters.getParametersSize() > 0 ? parameters.getList().getFirst().getValue() : new Parameter(0, "").getValue();
    }

    public Object getJavaCode() {
        StringBuilder sb = new StringBuilder("split").append("(");
        if (this.rowSeparator != null) {
            sb.append("\"").append(this.rowSeparator).append("\"");
        } else {
            sb.append("null");
        }
        sb.append(", ");
        if (this.columnSeparator != null) {
            sb.append("\"").append(this.columnSeparator).append("\"");
        } else {
            sb.append("null");
        }
        sb.append(", ").append(this.value.getJavaCode()).append(")");
        return sb.toString();
    }

    public List<ParameterList> getData() {
        ArrayList<ParameterList> params = new ArrayList<ParameterList>();
        String[] rows = null;
        rows = this.rowSeparator != null ? this.value.getCalculated().split("\\" + this.rowSeparator) : new String[]{this.value.getCalculated()};
        if (this.columnSeparator != null) {
            for (int i = 0; i < rows.length; ++i) {
                ParameterList paramRow = new ParameterList();
                String[] cols = rows[i].split("\\" + this.columnSeparator);
                for (int j = 0; j < cols.length; ++j) {
                    paramRow.addParameter(new Parameter(j, cols[j]));
                }
                params.add(paramRow);
            }
        } else {
            for (int i = 0; i < rows.length; ++i) {
                params.add(new ParameterList(rows[i]));
            }
        }
        return params;
    }

    public JsonElement toJson() {
        List<ParameterList> params = this.getData();
        JsonArray array = new JsonArray();
        int loop = 0;
        for (ParameterList param : params) {
            JsonObject obj = new JsonObject();
            obj.add("iter" + loop, new Gson().toJsonTree(param.getMap()));
            array.add((JsonElement)obj);
            ++loop;
        }
        return array;
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public void setRowSeparator(String rowSeparator) {
        this.rowSeparator = rowSeparator;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public CalculatedValue getValue() {
        return this.value;
    }

    public void setValue(CalculatedValue value) {
        this.value = value;
    }
}

