/*
 * Decompiled with CFR 0.152.
 */
package com.ats.gherkin;

import com.ats.script.actions.ActionAssertCount;
import com.ats.script.actions.ActionAssertProperty;
import com.ats.script.actions.ActionAssertValue;
import com.ats.script.actions.ActionButton;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionChannel;
import com.ats.script.actions.ActionChannelClose;
import com.ats.script.actions.ActionChannelExist;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionChannelSwitch;
import com.ats.script.actions.ActionGotoUrl;
import com.ats.script.actions.ActionMouse;
import com.ats.script.actions.ActionMouseScroll;
import com.ats.script.actions.ActionSelect;
import com.ats.script.actions.ActionText;
import com.ats.script.actions.ActionWindow;
import com.ats.script.actions.ActionWindowResize;
import com.ats.script.actions.ActionWindowState;
import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.Patch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GherkinTransformer {
    private Map<String, List<String>> transformationMap;
    private String gherkinFilePath;
    private String propertiesFilePath;
    private String projectPath;
    private List<String> atsContent;
    private final String dataPath = "src\\assets\\data\\";
    private final String atsFilesPath = "src\\main\\ats\\";
    private final String subStrCmd = "subscript_";
    private final String prefixDataFN = "data_";

    public GherkinTransformer(String projectPath, String gherkinFilePath, String propertiesFilePath) {
        this.projectPath = !projectPath.endsWith(File.separator) ? projectPath + File.separator : projectPath;
        this.gherkinFilePath = gherkinFilePath;
        this.propertiesFilePath = propertiesFilePath;
        this.transformationMap = this.readActionFile(propertiesFilePath);
        this.atsContent = new ArrayList<String>();
    }

    public void transform() throws IOException, NoSuchAlgorithmException {
        String fileName = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.gherkinFilePath));){
            String line;
            boolean lastLineWasEmpty = false;
            ArrayList<String> examplesHeaders = null;
            ArrayList<List<String>> examplesRows = new ArrayList<List<String>>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("Scenario") || line.startsWith("Scenario Outline")) {
                    fileName = this.setFileNameFromScenario(line);
                }
                if ((line.startsWith("Scenario") || line.startsWith("Scenario Outline") || line.startsWith("#Author") || line.startsWith("#URL")) && lastLineWasEmpty) {
                    this.writeFiles(fileName, examplesHeaders, examplesRows, this.atsContent);
                    this.atsContent.clear();
                    examplesHeaders = null;
                    examplesRows.clear();
                }
                lastLineWasEmpty = line.isEmpty();
                if (line.trim().toLowerCase().startsWith("examples:")) {
                    examplesHeaders = new ArrayList<String>();
                    String headersLine = reader.readLine().trim();
                    examplesHeaders.addAll(Arrays.asList(headersLine.split("\\|")));
                    examplesHeaders.removeIf(String::isEmpty);
                    continue;
                }
                if (examplesHeaders != null && line.trim().startsWith("|")) {
                    ArrayList<String> row = new ArrayList<String>(Arrays.asList(line.split("\\|")));
                    row.removeIf(String::isEmpty);
                    examplesRows.add(row);
                    continue;
                }
                if (line.isEmpty()) continue;
                this.atsContent = this.gherkinToAts(line, this.atsContent);
            }
            this.writeFiles(fileName, examplesHeaders, examplesRows, this.atsContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void applyGherkinChangesToAts() throws IOException, NoSuchAlgorithmException {
        int idx = -1;
        List<ScenarioStruct> lstDiffGherkin = this.compareGherkinToAts();
        if (lstDiffGherkin.isEmpty()) {
            return;
        }
        for (ScenarioStruct scenario : lstDiffGherkin) {
            List<List<String>> atsLines = this.readAtsFile(scenario.fileName);
            for (DiffStruct diff : scenario.lstDiff) {
                switch (diff.type.ordinal()) {
                    case 2: {
                        idx = this.findRowInAts(atsLines, diff.oldContent);
                        if (idx == -1) break;
                        atsLines.get(idx).set(0, "comment -> " + diff.newContent);
                        break;
                    }
                    case 0: {
                        List<Object> lst = new ArrayList<CallSite>(List.of("comment -> " + diff.newContent));
                        lst = this.gherkinToAts(diff.newContent, lst);
                        atsLines.add(diff.getIndex(), lst);
                    }
                }
            }
            for (DiffStruct diff : scenario.getDeletedDiff()) {
                idx = this.findRowInAts(atsLines, diff.oldContent);
                if (idx == -1) continue;
                atsLines.remove(idx);
            }
            List flatList = atsLines.stream().flatMap(Collection::stream).collect(Collectors.toList());
            Files.write(Paths.get(scenario.fileName, new String[0]), flatList, new OpenOption[0]);
        }
    }

    public void deleteAtsAndCsvFiles() {
        this.deleteFiles(this.projectPath + this.atsFilesPath, ".ats");
        this.deleteFiles(this.projectPath + this.dataPath, ".csv");
    }

    private List<String> gherkinToAts(String line, List<String> atsContent) {
        if (line.trim().toLowerCase().startsWith("examples") || line.trim().toLowerCase().startsWith("|")) {
            return atsContent;
        }
        String subscript = "subscript";
        atsContent.add("comment -> " + line);
        block40: for (Map.Entry<String, List<String>> entry : this.transformationMap.entrySet()) {
            for (String phrase : entry.getValue()) {
                if (!line.toLowerCase().contains(phrase.toLowerCase())) continue;
                switch (entry.getKey()) {
                    case "ActionGotoUrl": {
                        atsContent.add(ActionGotoUrl.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionText": {
                        atsContent.add(ActionText.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionAssertValue": {
                        atsContent.add(ActionAssertValue.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionClick": {
                        atsContent.add(ActionMouse.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionAssertCount": {
                        atsContent.add(ActionAssertCount.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionAssertProperty": {
                        atsContent.add(ActionAssertProperty.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionButton": {
                        atsContent.add(ActionButton.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionCallscript": {
                        atsContent.add(ActionCallscript.getAtsCodeStr().toString());
                        break;
                    }
                    case "ActionChannel": {
                        atsContent.add(ActionChannel.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionChannelClose": {
                        atsContent.add(ActionChannelClose.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionChannelExist": {
                        atsContent.add(ActionChannelExist.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionChannelStart": {
                        atsContent.add(ActionChannelStart.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionChannelSwitch": {
                        atsContent.add(ActionChannelSwitch.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionMouseScroll": {
                        atsContent.add(ActionMouseScroll.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionSelect": {
                        atsContent.add(ActionSelect.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionWindow": {
                        atsContent.add(ActionWindow.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionWindowResize": {
                        atsContent.add(ActionWindowResize.getAtsCodeStr(subscript).toString());
                        break;
                    }
                    case "ActionWindowState": {
                        atsContent.add(ActionWindowState.getAtsCodeStr(subscript).toString());
                        break;
                    }
                }
                continue block40;
            }
        }
        return atsContent;
    }

    private List<ScenarioStruct> compareGherkinToAts() throws IOException, NoSuchAlgorithmException {
        List<List<String>> gherkinLst = GherkinTransformer.splitFileByConditions(this.gherkinFilePath);
        ArrayList<ScenarioStruct> diffLst = new ArrayList<ScenarioStruct>(gherkinLst.size());
        for (int i = 0; i < gherkinLst.size(); ++i) {
            Object atsFileName = this.searchAtsFileName(gherkinLst.get(i));
            if (atsFileName == null) continue;
            atsFileName = this.setFileNameFromScenario((String)atsFileName) + ".ats";
            String fileName = this.fileExistsInDirectory(this.projectPath + this.atsFilesPath, this.subStrCmd + (String)atsFileName) ? this.projectPath + this.atsFilesPath + this.subStrCmd + (String)atsFileName : this.projectPath + this.atsFilesPath + (String)atsFileName;
            if (!this.fileExistsInDirectory(this.projectPath + this.atsFilesPath, (String)atsFileName)) {
                this.createNewScenario(gherkinLst.get(i));
                continue;
            }
            List<String> lstAtsComment = this.extractComments(fileName);
            List<String> subGherkinLst = gherkinLst.get(i);
            GherkinTransformer.removeDataFromScenario(subGherkinLst);
            List<DiffStruct> subDiffLst = this.compareGherkinToAts(subGherkinLst, lstAtsComment, new ArrayList<DiffStruct>());
            subDiffLst = this.compareGherkinToAts(subGherkinLst, lstAtsComment, subDiffLst);
            if (subDiffLst.isEmpty()) continue;
            diffLst.add(new ScenarioStruct(this, fileName, subDiffLst));
        }
        return diffLst;
    }

    private void createNewScenario(List<String> gherkinScenario) throws IOException {
        String fileName = null;
        ArrayList<String> examplesHeaders = new ArrayList<String>();
        ArrayList<List<String>> examplesRows = new ArrayList<List<String>>();
        List<String> atsContent = new ArrayList<String>();
        boolean firstDataLine = true;
        for (String gherkinStr : gherkinScenario) {
            if (gherkinStr.startsWith("Scenario") || gherkinStr.startsWith("Scenario Outline")) {
                fileName = this.setFileNameFromScenario(gherkinStr);
            }
            if (gherkinStr.trim().startsWith("|")) {
                if (firstDataLine) {
                    examplesHeaders = new ArrayList();
                    examplesHeaders.addAll(Arrays.asList(gherkinStr.split("\\|")));
                    examplesHeaders.removeIf(String::isEmpty);
                    firstDataLine = false;
                } else {
                    ArrayList<String> row = new ArrayList<String>(Arrays.asList(gherkinStr.split("\\|")));
                    row.removeIf(String::isEmpty);
                    examplesRows.add(row);
                }
            }
            atsContent = this.gherkinToAts(gherkinStr, atsContent);
        }
        if (fileName != null) {
            this.writeFiles(fileName, examplesHeaders, examplesRows, atsContent);
        }
    }

    private List<DiffStruct> compareGherkinToAts(List<String> gherkinScenario, List<String> lstAtsComment, List<DiffStruct> subDiffLst) throws NoSuchAlgorithmException {
        Patch patch = DiffUtils.diff(lstAtsComment, gherkinScenario);
        for (AbstractDelta delta : patch.getDeltas()) {
            if (delta.getType() == DeltaType.INSERT) {
                List addedLines = delta.getTarget().getLines();
                for (int j = 0; j < addedLines.size(); ++j) {
                    int addedIndex = delta.getTarget().getPosition() + j;
                    if (subDiffLst.stream().anyMatch(diff -> diff.getIndex() == addedIndex && diff.getType() == DiffStruct.DiffType.ADDED)) continue;
                    subDiffLst.add(new DiffStruct(this, DiffStruct.DiffType.ADDED, addedIndex, (String)addedLines.get(j), ""));
                }
                continue;
            }
            if (delta.getType() == DeltaType.DELETE) {
                List deletedLines = delta.getSource().getLines();
                for (int j = 0; j < deletedLines.size(); ++j) {
                    int deletedIndex = delta.getSource().getPosition() + j;
                    DiffStruct line = new DiffStruct(this, DiffStruct.DiffType.DELETED, deletedIndex, "", (String)deletedLines.get(j));
                    if (subDiffLst.contains(line)) continue;
                    subDiffLst.add(line);
                }
                continue;
            }
            if (delta.getType() != DeltaType.CHANGE) continue;
            List originalLines = delta.getSource().getLines();
            List revisedLines = delta.getTarget().getLines();
            for (int j = 0; j < originalLines.size(); ++j) {
                int originalIndex = delta.getSource().getPosition() + j;
                int revisedIndex = delta.getTarget().getPosition() + j;
                if (j < revisedLines.size()) {
                    int levenDist = this.calculateLevenshteinDistance((String)originalLines.get(j), (String)revisedLines.get(j));
                    if (levenDist > 40) {
                        DiffStruct line1 = new DiffStruct(this, DiffStruct.DiffType.DELETED, originalIndex, "", (String)originalLines.get(j));
                        DiffStruct line2 = new DiffStruct(this, DiffStruct.DiffType.ADDED, revisedIndex, (String)revisedLines.get(j), "");
                        subDiffLst.add(line1);
                        subDiffLst.add(line2);
                    } else {
                        subDiffLst.add(new DiffStruct(this, DiffStruct.DiffType.MODIFIED, revisedIndex, (String)revisedLines.get(j), (String)originalLines.get(j)));
                    }
                    lstAtsComment.set(originalIndex, (String)revisedLines.get(j));
                    continue;
                }
                subDiffLst.add(new DiffStruct(this, DiffStruct.DiffType.DELETED, originalIndex, "", (String)originalLines.get(j)));
            }
        }
        return subDiffLst;
    }

    private List<List<String>> readAtsFile(String filePath) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]));
        ArrayList<List<String>> atsFile = new ArrayList<List<String>>();
        ArrayList<String> lst = null;
        for (String line : lines) {
            if (line.trim().startsWith("comment ->")) {
                if (lst != null) {
                    atsFile.add((List<String>)lst);
                }
                lst = new ArrayList<String>();
            }
            lst.add(line.trim());
        }
        if (lst != null) {
            atsFile.add(lst);
        }
        return atsFile;
    }

    private String searchAtsFileName(List<String> lstScenario) {
        Optional<String> result = lstScenario.stream().map(String::trim).filter(element -> element.startsWith("Scenario")).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        return null;
    }

    private void deleteFiles(String path, String extension) {
        File[] files;
        File directory = new File(path);
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles((dir, name) -> name.endsWith(""))) != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    private void writeFiles(String fileName, List<String> dataHeaders, List<List<String>> dataRows, List<String> atsContent) throws IOException {
        if (fileName == null) {
            return;
        }
        if (!atsContent.isEmpty()) {
            String filename = fileName + ".ats";
            String dataFilename = "data_" + fileName + ".csv";
            if (dataHeaders != null && !dataRows.isEmpty()) {
                this.writeAtsBaseFile(filename, dataFilename);
                this.writeAtsFile(this.projectPath + this.atsFilesPath + "subscript_" + filename, atsContent);
                this.writeExamplesToCsv(this.projectPath + this.dataPath + dataFilename, dataHeaders, dataRows);
            } else {
                this.writeAtsFile(this.projectPath + this.atsFilesPath + filename, atsContent);
            }
        }
    }

    private void writeAtsFile(String outputFilePath, List<String> atsContent) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath));){
            for (String line : atsContent) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    private void writeAtsBaseFile(String atsFileName, String dataFileName) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.projectPath + this.atsFilesPath + atsFileName));){
            writer.write("callscript -> subscript_" + atsFileName + " -> assets:///data/" + dataFileName);
            writer.newLine();
        }
    }

    private Map<String, List<String>> readActionFile(String filePath) {
        HashMap<String, List<String>> transformationMap = new HashMap<String, List<String>>();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (line.trim().isEmpty() || line.trim().startsWith("#") || (parts = line.split("=", 2)).length != 2) continue;
                String action = parts[0].trim();
                String[] phrases = parts[1].split("\\|");
                ArrayList<String> phraseList = new ArrayList<String>();
                for (String phrase : phrases) {
                    phraseList.add(phrase.trim());
                }
                transformationMap.put(action, phraseList);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return transformationMap;
    }

    private void writeExamplesToCsv(String fileName, List<String> dataHeaders, List<List<String>> dataRows) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
            ArrayList<CallSite> formattedHeaders = new ArrayList<CallSite>();
            for (String string : dataHeaders) {
                formattedHeaders.add((CallSite)((Object)("<" + string.trim() + ">")));
            }
            writer.write(String.join((CharSequence)",", formattedHeaders));
            writer.newLine();
            for (List list : dataRows) {
                writer.write(String.join((CharSequence)",", list));
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String setFileNameFromScenario(String scenarioName) {
        String filename = scenarioName.substring(scenarioName.indexOf(":") + 1).trim();
        filename = filename.replace(" ", "_");
        return filename;
    }

    public static List<List<String>> splitFileByConditions(String filePath) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]));
        ArrayList<List<String>> separatedLists = new ArrayList<List<String>>();
        ArrayList<String> currentList = new ArrayList<String>();
        boolean lastLineWasEmpty = true;
        for (String line : lines) {
            if (line.trim().isEmpty()) {
                lastLineWasEmpty = true;
                continue;
            }
            if ((line.startsWith("Scenario") || line.startsWith("Scenario Outline") || line.startsWith("#Author") || line.startsWith("#URL")) && lastLineWasEmpty) {
                if (!currentList.isEmpty()) {
                    separatedLists.add(currentList);
                }
                currentList = new ArrayList();
            }
            currentList.add(line.trim());
            lastLineWasEmpty = false;
        }
        if (!currentList.isEmpty()) {
            separatedLists.add(currentList);
        }
        return separatedLists;
    }

    public boolean fileExistsInDirectory(String directoryPath, String fileName) {
        Path filePath = Paths.get(directoryPath, fileName);
        return Files.exists(filePath, new LinkOption[0]);
    }

    public int calculateLevenshteinDistance(String str1, String str2) {
        int i;
        int[][] dp = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= str2.length(); ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                int cost = str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1;
                dp[i][j] = Math.min(Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1), dp[i - 1][j - 1] + cost);
            }
        }
        return dp[str1.length()][str2.length()];
    }

    private static void removeDataFromScenario(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).trim().toLowerCase().startsWith("examples") && !list.get(i).trim().toLowerCase().startsWith("|")) continue;
            list.subList(i, list.size()).clear();
            break;
        }
    }

    private int findRowInAts(List<List<String>> atsLines, String toFind) {
        for (int i = 0; i < atsLines.size(); ++i) {
            String lineWithoutPrefix;
            String atsLine = atsLines.get(i).get(0);
            if (!atsLine.startsWith("comment -> ") || !(lineWithoutPrefix = atsLine.substring("comment -> ".length())).equals(toFind)) continue;
            return i;
        }
        return -1;
    }

    private List<String> extractComments(String filePath) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]));
        ArrayList<String> comments = new ArrayList<String>();
        for (String line : lines) {
            if (!line.trim().startsWith("comment ->")) continue;
            comments.add(line.substring(10).trim());
        }
        return comments;
    }

    public class ScenarioStruct {
        public String fileName;
        public List<DiffStruct> lstDiff;

        public ScenarioStruct(GherkinTransformer this$0, String name, List<DiffStruct> lstDiff) {
            this.fileName = name;
            this.lstDiff = lstDiff;
        }

        public List<DiffStruct> getAddedDiff() {
            return this.getDiff(DiffStruct.DiffType.ADDED);
        }

        public List<DiffStruct> getDeletedDiff() {
            return this.getDiff(DiffStruct.DiffType.DELETED);
        }

        public List<DiffStruct> getModifiedDiff() {
            return this.getDiff(DiffStruct.DiffType.MODIFIED);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Scenario [name=").append(this.fileName).append("\n");
            for (DiffStruct diff : this.lstDiff) {
                sb.append("   ").append(diff.toString()).append("\n");
            }
            sb.append("]");
            return sb.toString();
        }

        private List<DiffStruct> getDiff(DiffStruct.DiffType diffType) {
            List<DiffStruct> addedDiffs = this.lstDiff.stream().filter(diff -> diff.getType() == diffType).collect(Collectors.toList());
            return addedDiffs;
        }
    }

    public class DiffStruct
    implements Comparable<DiffStruct> {
        private DiffType type;
        private int index;
        private String newContent;
        private String oldContent;

        public DiffStruct(GherkinTransformer this$0, DiffType type, int index, String newContent, String oldContent) {
            this.type = type;
            this.index = index;
            this.newContent = newContent;
            this.oldContent = oldContent;
        }

        public DiffType getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }

        public String getNewContent() {
            return this.newContent;
        }

        public String toString() {
            return "Diff [type=" + String.valueOf((Object)this.type) + ", index=" + this.index + ", newContent=" + this.newContent + ", oldContent=" + this.oldContent + "]";
        }

        @Override
        public int compareTo(@NotNull DiffStruct other) {
            int contentComparison = this.newContent.compareTo(other.newContent);
            if (contentComparison != 0) {
                return contentComparison;
            }
            int indexComparison = Integer.compare(this.index, other.index);
            if (indexComparison != 0) {
                return indexComparison;
            }
            return this.type.compareTo(other.type);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DiffStruct that = (DiffStruct)other;
            return this.index == that.index && this.type == that.type && Objects.equals(this.newContent, that.newContent);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.index, this.newContent});
        }

        public static enum DiffType {
            ADDED,
            DELETED,
            MODIFIED;

        }
    }
}

