/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.AtsSingleton;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.recorder.IVisualRecorder;
import com.ats.recorder.TestError;
import com.ats.recorder.VisualAction;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Action {
    public static final String DATA_JSON = "dataJson";
    protected Script script;
    protected ActionStatus status;
    protected int line;
    protected boolean disabled = false;
    protected long timeLine;
    private String code;
    private Channel currentChannel;

    public Action() {
    }

    public Action(Script script) {
        this.script = script;
    }

    public void setCode(String value) {
        this.code = value;
    }

    public String getAtsCode() {
        return this.code;
    }

    public Element getXmlElement(Document document, ScriptHeader header, int index) {
        Element actionElem = document.createElement("action");
        actionElem.setAttribute("index", String.valueOf(index));
        actionElem.setAttribute("type", this.getClass().getName());
        actionElem.appendChild(document.createElement("line")).setTextContent(String.valueOf(this.getLine()));
        actionElem.appendChild(document.createElement("script")).setTextContent(header.getQualifiedName());
        actionElem.appendChild(document.createElement("timeLine")).setTextContent(String.valueOf(this.timeLine));
        actionElem.appendChild(document.createElement("error")).setTextContent(String.valueOf(this.status.getCode()));
        actionElem.appendChild(document.createElement("stop")).setTextContent("true");
        actionElem.appendChild(document.createElement("duration")).setTextContent("0");
        actionElem.appendChild(document.createElement("passed")).setTextContent(String.valueOf(this.status.isPassed()));
        Element img = document.createElement("img");
        img.setAttribute("height", "100");
        img.setAttribute("height", "150");
        img.setAttribute("type", "png");
        img.setAttribute("src", "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");
        actionElem.appendChild(img);
        return actionElem;
    }

    public VisualAction getVisualAction() {
        return new VisualAction(this, this.timeLine);
    }

    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = new StringBuilder("exec");
        codeBuilder.append("(").append(this.getLine()).append(", ").append("new ").append(this.getClass().getSimpleName()).append("(this, ");
        return codeBuilder;
    }

    public boolean isScriptComment() {
        return false;
    }

    public ArrayList<String> getKeywords() {
        return new ArrayList<String>();
    }

    public boolean isPassed() {
        return this.status.isPassed();
    }

    public long getExecutionDuration() {
        return this.getStatus().endDuration();
    }

    public void execute(ActionTestScript ts, String testName, int line, int tryNum) {
        if (this.script == null) {
            this.setScript(ts);
        }
        this.script.setLastAction(this);
        this.execute(ts, testName, line, tryNum == 0);
    }

    protected void execute(ActionTestScript ts, String testName, int line, boolean firstTry) {
        this.line = line;
        this.currentChannel = AtsSingleton.getInstance().getCurrentChannel();
        this.currentChannel.newActionStatus(this, ts.getRecorder(), testName, line, firstTry);
    }

    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        if (!this.status.isPassed()) {
            data = new JsonObject();
            data.addProperty("status", "non blocking action");
            data.addProperty("message", this.status.getFailMessage());
        }
        data.addProperty("passed", Boolean.valueOf(this.status.isPassed()));
        data.addProperty("duration", (Number)this.status.endDuration());
        JsonObject script = new JsonObject();
        script.addProperty("name", scriptName);
        script.addProperty("line", (Number)scriptLine);
        data.add("script", (JsonElement)script);
        return new StringBuilder(this.getClass().getSimpleName()).append(" -> ").append(data.toString());
    }

    protected void saveAppSource() {
        this.currentChannel.saveAppSource(this.script.getTestName());
    }

    public void failed(int errorCode, String errorMessage) {
        this.status.setError(errorCode, errorMessage);
    }

    public void addShadowActionError(int line, TestError.TestErrorStatus testErrorStatus) {
        if (this.getScript() != null) {
            this.getScript().addShadowActionError(this, line, this.getStatus().getFailMessage(), testErrorStatus);
        }
    }

    public String addShadowAction() {
        if (this.getScript() != null) {
            this.getScript().addShadowAction(this);
        }
        return UUID.randomUUID().toString();
    }

    public void initAction(Channel channel, IVisualRecorder recorder, ActionStatus status) {
        channel.startHarAction(this, status.getTestNameLine(), channel.createVisualAction(recorder, this, status.getTestName(), status.getTestLine()));
    }

    protected Channel getCurrentChannel() {
        return this.currentChannel;
    }

    public void setTimeline(long value) {
        this.timeLine = value;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public ActionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ActionStatus status) {
        this.status = status;
    }
}

