/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.tools.Operators;
import com.ats.tools.Utils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActionAssertCount
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "check-count";
    public static final String SCRIPT_OCCURRENCE_LABEL = "check-occurrence";
    public static final Predicate<String> PREDICATE = "check-count"::equals;
    public static final Predicate<String> PREDICATE_OCCURRENCE = "check-occurrence"::equals;
    private final Pattern COUNT_PATTERN = Pattern.compile("(\\d+) ?(\\-?\\+?=?!?)");
    private int value = 1;
    private String operator = "=";

    public ActionAssertCount() {
    }

    public ActionAssertCount(AtsScript script, ExecuteOptions options, int stopPolicy, String data, ArrayList<String> objectArray) {
        super(script, options, stopPolicy, objectArray);
        Matcher m = this.COUNT_PATTERN.matcher(data);
        if (m.matches()) {
            this.setValue(Utils.string2Int(m.group(1).trim(), 1));
            if (m.groupCount() > 1) {
                switch (m.group(2).trim()) {
                    case "+": {
                        this.setOperator(">=");
                        break;
                    }
                    case "-": {
                        this.setOperator("<=");
                        break;
                    }
                    case "!": {
                        this.setOperator("<>");
                    }
                }
            }
        }
    }

    public ActionAssertCount(AtsScript script, ExecuteOptions options, int stopPolicy, String operator, String calculate, ArrayList<String> objectArray) {
        super(script, options, stopPolicy, objectArray);
    }

    public ActionAssertCount(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, String operator, int value) {
        super(script, options, stopPolicy, maxTry, delay, element);
        this.setOperator(operator);
        this.setValue(value);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(", ").append(Operators.getJavaCode(this.operator)).append(", ").append(this.value).append(")");
        return codeBuilder;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        if (this.getCondition().isPassed()) {
            super.execute(ts, testName, testLine, this.operator, this.value, tryNum);
        }
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        this.getTestElement().checkOccurrences(ts, this.status, this.operator, this.value);
        this.status.getElement().setFoundElements(null);
        ts.getRecorder().updateScreen(false);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("operator", this.operator);
        data.addProperty("occurrences", (Number)this.value);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("callscript -> ").append(subFolder).append(".AssertCount");
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }
}

