/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.AtsSingleton;
import com.ats.executor.ActionTestScript;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionCondition;
import com.ats.script.actions.IActionStoppable;
import com.ats.script.actions.condition.ExecuteOptions;
import java.util.ArrayList;
import java.util.function.Predicate;

public class ActionButton
extends ActionCondition
implements IActionStoppable {
    public static final String SCRIPT_LABEL = "button";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g);
    private String buttonType = "home";

    public ActionButton() {
    }

    public ActionButton(Script script, ExecuteOptions options, String buttonType) {
        super(script, options);
        this.setButtonType(buttonType);
    }

    public ActionButton(AtsScript script, ArrayList<String> dataArray) {
        String[] data = dataArray.get(0).split("=");
        if (data.length == 2) {
            this.setButtonType(data[1].replace("]", "").trim());
        }
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        if (AtsSingleton.getInstance().getCurrentChannel() != null) {
            AtsSingleton.getInstance().getCurrentChannel().buttonClick(this.status, this.getButtonType());
        }
        ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), this.getButtonType());
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append("\"").append(this.buttonType).append("\")");
    }

    @Override
    public boolean isStop() {
        return true;
    }

    public String getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(String value) {
        this.buttonType = value;
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("callscript -> ").append(subFolder).append(".Button");
    }
}

