/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionChannelExist;
import com.ats.script.actions.condition.ExecuteOptions;
import java.util.function.Predicate;

public class ActionChannelClose
extends ActionChannelExist {
    public static final String SCRIPT_CLOSE_LABEL = "channel-close";
    public static final String NO_STOP_LABEL = "nostop";
    public static final Predicate<String> PREDICATE = "channel-close"::equals;
    private boolean keepRunning = false;

    public ActionChannelClose() {
    }

    public ActionChannelClose(Script script, ExecuteOptions options, String name) {
        super(script, options, name);
        this.setKeepRunning(options.hasNoStopLabel());
    }

    public ActionChannelClose(Script script, ExecuteOptions options, String name, boolean run) {
        super(script, options, name);
        this.setKeepRunning(run);
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        this.getCurrentChannel().closeChannel(this.status, ts, testName, testLine, this.getName());
    }

    public boolean isKeepRunning() {
        return this.keepRunning;
    }

    public void setKeepRunning(boolean keepRunning) {
        this.keepRunning = keepRunning;
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append("\"").append(this.getName()).append("\", ").append(this.keepRunning).append(")");
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("callscript -> ").append(subFolder).append(".Close");
    }
}

