/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ActionDownload
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "download";
    public static final Predicate<String> PREDICATE = g -> g.startsWith(SCRIPT_LABEL);
    private static final String DEFAULT_FILE_NAME = "ats_downloaded_file";
    private CalculatedValue destinationFolder;
    private String downloadUrl = null;
    private Path filePath = null;
    private long fileSize = 0L;
    private ProgressListener progressListener;
    private final OkHttpClient client = new OkHttpClient.Builder().retryOnConnectionFailure(true).protocols(List.of(Protocol.HTTP_1_1)).build();

    public ActionDownload() {
    }

    public ActionDownload(AtsScript script, ExecuteOptions options, int stopPolicy, String destinationFolder, ArrayList<String> objectArray) {
        super(script, options, stopPolicy, objectArray);
        this.setDestinationFolder(new CalculatedValue(script, destinationFolder));
    }

    public ActionDownload(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedValue text) {
        super(script, options, stopPolicy, maxTry, delay, element);
        this.setDestinationFolder(text);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode().append(", ").append(this.destinationFolder.getJavaCode());
        codeBuilder.append(")");
        return codeBuilder;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            this.downloadUrl = this.testElement.getAttribute(this.status, "href");
            if (this.downloadUrl == null) {
                this.terminateExecutionWithError(ts, -5, "attribute 'href' is not set to this element");
                return;
            }
            if (this.downloadUrl.isBlank()) {
                this.terminateExecutionWithError(ts, -5, "attribute 'href' is empty");
                return;
            }
            if (this.downloadUrl.startsWith("javascript:") || this.downloadUrl.startsWith("#")) {
                this.terminateExecutionWithError(ts, -31, "attribute 'href' is not an hyperlink: " + this.downloadUrl);
                return;
            }
            if (!this.downloadUrl.startsWith("http") || !this.downloadUrl.startsWith("https")) {
                WebDriverEngine engine = (WebDriverEngine)this.getCurrentChannel().getDriverEngine();
                String baseUrl = engine.getAtsRemoteDriver().getCurrentUrl();
                try {
                    if (baseUrl != null) {
                        URI base = new URI(baseUrl);
                        URI resolved = base.resolve(this.downloadUrl);
                        this.downloadUrl = resolved.toString();
                    }
                }
                catch (URISyntaxException e) {
                    this.terminateExecutionWithError(ts, -10, "URL syntax error: " + e.getMessage());
                    return;
                }
            }
            String folder = this.getDestinationFolder().getCalculated();
            Path folderPath = null;
            if (folder.startsWith("file:///")) {
                folder = folder.replace("\\", "/");
                try {
                    URI uri = new URI(folder);
                    folderPath = Paths.get(uri);
                }
                catch (URISyntaxException uri) {}
            } else {
                folderPath = Paths.get(folder, new String[0]);
            }
            if (folderPath == null) {
                this.terminateExecutionWithError(ts, -25, "unable to get folder: " + folder);
                return;
            }
            try {
                Files.createDirectories(folderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.terminateExecutionWithError(ts, -25, "error when creating directories: " + e.getMessage());
                return;
            }
            this.filePath = folderPath.resolve(DEFAULT_FILE_NAME);
            ProgressListener effectiveListener = this.progressListener != null ? this.progressListener : (read, total) -> {
                StringBuilder sb = new StringBuilder("[ATS-DOWNLOAD-DEFAULT]");
                if (total > 0L) {
                    sb.append(" in progress -> ").append(read * 100L / total).append("%");
                } else {
                    if (total == -1L) {
                        sb.append(" complete -> ");
                    } else {
                        sb.append(" in progress -> ");
                    }
                    sb.append(read).append(" bytes downloaded");
                }
                System.out.println(sb);
            };
            try {
                this.downloadFile(this.downloadUrl, this.filePath, effectiveListener);
            }
            catch (IOException e) {
                this.terminateExecutionWithError(ts, -25, "an issue occurred during the download: " + e.getMessage());
                return;
            }
            JsonObject data = new JsonObject();
            data.addProperty("file", this.filePath.toString());
            data.addProperty("fileSize", (Number)this.fileSize);
            ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), this.downloadUrl, data.toString());
        } else {
            this.terminateExecution(ts, this.status.getCode(), "", "");
        }
    }

    public void setProgressListener(ProgressListener listener) {
        this.progressListener = listener;
    }

    public void downloadFile(String url, Path file, ProgressListener listener) throws IOException {
        Request request = new Request.Builder().url(url).addHeader("Range", "bytes=0-").addHeader("User-Agent", "Mozilla/5.0").build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("download failed: " + response.code());
            }
            ResponseBody body = response.body();
            long contentLength = body.contentLength();
            try (InputStream in = body.byteStream();
                 FileOutputStream out = new FileOutputStream(file.toFile());){
                int read;
                byte[] buffer = new byte[8192];
                this.fileSize = 0L;
                int loop = 0;
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                    this.fileSize += (long)read;
                    if (loop > 10240) {
                        loop = 0;
                        listener.onProgress(this.fileSize, contentLength);
                    }
                    ++loop;
                }
                listener.onProgress(this.fileSize, -1L);
            }
        }
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("url", this.downloadUrl);
        data.addProperty("file", this.filePath.toString());
        data.addProperty("fileSize", (Number)this.fileSize);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedValue getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setDestinationFolder(CalculatedValue destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public static interface ProgressListener {
        public void onProgress(long var1, long var3);
    }
}

