/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionReturnVariable;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;

public class ActionScripting
extends ActionReturnVariable {
    public static final String JAVASCRIPT_LABEL = "javascript";
    public static final String SCRIPT_LABEL = "scripting";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g) || JAVASCRIPT_LABEL.equals(g);
    private CalculatedValue jsCode;

    public ActionScripting() {
    }

    public ActionScripting(AtsScript script, ExecuteOptions options, int stopPolicy, String code, Variable variable, ArrayList<String> objectArray) {
        super((Script)script, options, stopPolicy, objectArray, variable);
        this.setJsCode(new CalculatedValue(script, code));
    }

    public ActionScripting(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedValue jsCode, Variable variable) {
        super(script, options, stopPolicy, maxTry, delay, element, variable);
        this.setJsCode(jsCode);
    }

    @Override
    public StringBuilder getJavaCode() {
        String variableCode = "null";
        if (this.getVariable() != null) {
            variableCode = this.getVariable().getName();
        }
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(", ").append(this.jsCode.getJavaCode()).append(", ").append(variableCode).append(")");
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.jsCode.getKeywords());
        return keywords;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.variable != null) {
            if (this.status.isPassed()) {
                Object result = this.getTestElement().executeScript(this.status, this.jsCode.getCalculated(), true);
                if (result != null) {
                    this.updateVariableValue(result.toString());
                }
            } else {
                this.status.setMessage("");
                this.updateVariableValue("");
            }
        } else {
            this.getTestElement().executeScript(this.status, this.jsCode.getCalculated(), false);
        }
        this.status.endAction();
        ts.getRecorder().updateScreen(this.status, this.jsCode.getCalculated());
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("code", this.jsCode.getCalculated());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedValue getJsCode() {
        return this.jsCode;
    }

    public void setJsCode(CalculatedValue jsCode) {
        this.jsCode = jsCode;
    }
}

