/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.network;

import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.actions.network.ActionNetwork;
import java.util.function.Predicate;

public class ActionNetworkRecord
extends ActionNetwork {
    public static final String SCRIPT_LABEL = "net-record";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g);
    public static final String PAUSE = "pause";
    public static final String RESUME = "resume";
    private String type = "pause";

    public ActionNetworkRecord() {
    }

    public ActionNetworkRecord(Script script, String type) {
        super(script);
        this.setType(type);
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append("\"").append(this.type).append("\"").append(")");
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        if (PAUSE.equals(this.type)) {
            this.getCurrentChannel().pauseHarRecord();
        } else {
            this.getCurrentChannel().resumeHarRecord();
        }
        ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), this.type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = RESUME.equals(type) ? type : PAUSE;
    }
}

