/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.IntConsumer;

public class ReadableConsumerByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel rbc;
    private final IntConsumer onRead;
    private final int totalBytes;
    private int totalByteRead;
    private int currentPercent = 0;

    public ReadableConsumerByteChannel(ReadableByteChannel rbc, int totalBytes, IntConsumer onBytesRead) {
        this.rbc = rbc;
        this.totalBytes = totalBytes;
        this.onRead = onBytesRead;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int nRead = this.rbc.read(dst);
        this.notifyBytesRead(nRead);
        return nRead;
    }

    protected void notifyBytesRead(int nRead) {
        if (nRead <= 0) {
            return;
        }
        this.totalByteRead += nRead;
        if (this.totalBytes != -1) {
            int percent = (int)((float)this.totalByteRead / (float)this.totalBytes * 100.0f);
            if (percent % 5 == 0 && this.currentPercent != percent) {
                this.currentPercent = percent;
                this.onRead.accept(this.currentPercent);
            }
        } else if (this.totalByteRead % 10000 == 0) {
            this.onRead.accept(this.totalByteRead / 10000);
        }
    }

    @Override
    public boolean isOpen() {
        return this.rbc.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.rbc.close();
    }
}

