/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

import com.ats.tools.JSMin;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class ResourceContent {
    private static String JAVASCRIPT = "javascript";
    private static String scrollElementJavaScript;
    private static String searchElementsJavaScript;
    private static String searchInputFileElementsJavaScript;
    private static String searchShadowElementsJavaScript;
    private static String documentSizeJavaScript;
    private static String elementAttributesJavaScript;
    private static String elementKeysAndAttributesJavaScript;
    private static String elementFunctionsJavaScript;
    private static String elementTextDataJavaScript;
    private static String elementTextJavaScript;
    private static String elementValueJavaScript;
    private static String elementCheckedJavaScript;
    private static String parentElementJavaScript;
    private static String parentElementHtmlCode;
    private static String parentElementJavaScriptIE;
    private static String htmlReportTemplate;
    private static String htmlReportActionHtmlTemplate;
    private static String htmlReportCss;
    private static String htmlReportJavascript;
    private static String htmlReportOneElementDataActionTemplate;
    private static String htmlReportTwoElementsDataActionTemplate;
    private static String htmlReportOneElementDataActionTemplate_AsaSuite;
    private static String htmlReportTwoElementsDataActionTemplate_AsaSuite;
    private static String htmlReportThreeElementsDataActionTemplate;
    private static String htmlReportApiCallActionTemplate;
    private static String htmlReportAssertPropertyActionTemplate;
    private static String htmlReportAssertOccurrenceActionTemplate;
    private static String htmlReportAssertValueActionTemplate;
    private static String htmlReportPlaylistTemplate;
    private static String htmlReportSuiteTemplate;
    private static String htmlReportExecutionTemplate;
    private static String atsLogo;
    private static String pageStyle;
    private static String htmlReportSummaryTemplate;
    private static String htmlReportSummarySuiteTemplate;
    private static String htmlReportSummaryTestCaseTemplate;
    private static String htmlReportFooter;

    private static String getResource(boolean webdriver, String type, String resourceName) {
        try {
            StringBuilder sb = new StringBuilder("/").append(type).append("/").append(resourceName).append(".").append(type.equals(JAVASCRIPT) ? "js" : type);
            String fileContent = Resources.toString((URL)ResourceContent.class.getResource(sb.toString()), (Charset)StandardCharsets.UTF_8);
            if (webdriver) {
                StringReader in = new StringReader(fileContent);
                StringWriter out = new StringWriter();
                JSMin minifier = new JSMin(in, out);
                minifier.jsmin();
                return out.toString();
            }
            return ResourceContent.stripNewlinesTabs(fileContent);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String stripNewlinesTabs(String fileContent) {
        int len = fileContent.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = fileContent.charAt(i);
            if (c == '\n' || c == '\t' || c == '\r') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getScript(String resourceName) {
        return ResourceContent.getResource(false, "javascript", resourceName);
    }

    public static String getScript(boolean webdriver, String resourceName) {
        return ResourceContent.getResource(webdriver, "javascript", resourceName);
    }

    public static String getCss(String resourceName) {
        return ResourceContent.getResource(false, "css", resourceName);
    }

    public static String getHtml(String resourceName) {
        return ResourceContent.getResource(false, "html", resourceName);
    }

    public static byte[] getAtsByteLogo() {
        try {
            return Resources.toByteArray((URL)ResourceContent.class.getResource("/icons/ats_logo.png"));
        }
        catch (IOException e1) {
            return new byte[0];
        }
    }

    public static String getData(String name) {
        try {
            return Resources.toString((URL)ResourceContent.class.getResource("/" + name), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e1) {
            return "";
        }
    }

    public static String getPageStyle() {
        return pageStyle;
    }

    public static String getAtsLogo() {
        return atsLogo;
    }

    public static String getScrollElementJavaScript() {
        return scrollElementJavaScript;
    }

    public static String getSearchElementsJavaScript() {
        return searchElementsJavaScript;
    }

    public static String getSearchInputFileElementsJavaScript() {
        return searchInputFileElementsJavaScript;
    }

    public static String getSearchShadowElementsJavaScript() {
        return searchShadowElementsJavaScript;
    }

    public static String getDocumentSizeJavaScript() {
        return documentSizeJavaScript;
    }

    public static String getElementAttributesJavaScript() {
        return elementAttributesJavaScript;
    }

    public static String getElementKeysAndAttributesJavaScript() {
        return elementKeysAndAttributesJavaScript;
    }

    public static String getElementFunctionsJavaScript() {
        return elementFunctionsJavaScript;
    }

    public static String getElementTextDataJavaScript() {
        return elementTextDataJavaScript;
    }

    public static String getElementTextJavaScript() {
        return elementTextJavaScript;
    }

    public static String getElementValueJavaScript() {
        return elementValueJavaScript;
    }

    public static String getElementCheckedJavaScript() {
        return elementCheckedJavaScript;
    }

    public static String getParentElementJavaScript() {
        return parentElementJavaScript;
    }

    public static String getParentElementHtmlCode() {
        return parentElementHtmlCode;
    }

    public static String getParentElementJavaScriptIE() {
        return parentElementJavaScriptIE;
    }

    public static String getHtmlReportActionHtmlTemplate() {
        return htmlReportActionHtmlTemplate;
    }

    public static String getHtmlReportCss() {
        return htmlReportCss;
    }

    public static String getHtmlReportTemplate() {
        return htmlReportTemplate;
    }

    public static String getHtmlReportJavascript() {
        return htmlReportJavascript;
    }

    public static String getHtmlReportOneElementDataActionTemplate() {
        return htmlReportOneElementDataActionTemplate;
    }

    public static String getHtmlReportOneElementDataActionTemplate_AsaSuite() {
        return htmlReportOneElementDataActionTemplate_AsaSuite;
    }

    public static String getHtmlReportTwoElementsDataActionTemplate() {
        return htmlReportTwoElementsDataActionTemplate;
    }

    public static String getHtmlReportTwoElementsDataActionTemplate_AsaSuite() {
        return htmlReportTwoElementsDataActionTemplate_AsaSuite;
    }

    public static String getHtmlReportThreeElementsDataActionTemplate() {
        return htmlReportThreeElementsDataActionTemplate;
    }

    public static String getHtmlReportPlaylistTemplate() {
        return htmlReportPlaylistTemplate;
    }

    public static String getHtmlReportSuiteTemplate() {
        return htmlReportSuiteTemplate;
    }

    public static String getHtmlReportExecutionTemplate() {
        return htmlReportExecutionTemplate;
    }

    public static String getHtmlReportApiCallActionTemplate() {
        return htmlReportApiCallActionTemplate;
    }

    public static String getHtmlReportAssertPropertyActionTemplate() {
        return htmlReportAssertPropertyActionTemplate;
    }

    public static String getHtmlReportAssertOccurrenceActionTemplate() {
        return htmlReportAssertOccurrenceActionTemplate;
    }

    public static String getHtmlReportAssertValueActionTemplate() {
        return htmlReportAssertValueActionTemplate;
    }

    public static String getHtmlReportSummaryTemplate() {
        return htmlReportSummaryTemplate;
    }

    public static String getHtmlReportSummarySuiteTemplate() {
        return htmlReportSummarySuiteTemplate;
    }

    public static String getHtmlReportSummaryTestCaseTemplate() {
        return htmlReportSummaryTestCaseTemplate;
    }

    public static String getHtmlFooter() {
        return htmlReportFooter;
    }

    static {
        documentSizeJavaScript = ResourceContent.getScript(true, "documentSize");
        elementAttributesJavaScript = ResourceContent.getScript(true, "elementAttributes");
        elementKeysAndAttributesJavaScript = ResourceContent.getScript(true, "elementKeysAndAttributes");
        elementFunctionsJavaScript = ResourceContent.getScript(true, "elementFunctions");
        parentElementJavaScript = ResourceContent.getScript(true, "parentElement");
        parentElementHtmlCode = ResourceContent.getScript(true, "parentElementHtmlCode");
        parentElementJavaScriptIE = ResourceContent.getScript(true, "parentElementIE");
        scrollElementJavaScript = ResourceContent.getScript(true, "scrollElement");
        searchElementsJavaScript = ResourceContent.getScript(true, "searchElements");
        searchInputFileElementsJavaScript = ResourceContent.getScript(true, "searchInputFileElements");
        elementTextDataJavaScript = ResourceContent.getScript(true, "elementTextData");
        elementTextJavaScript = ResourceContent.getScript(true, "elementText");
        elementValueJavaScript = ResourceContent.getScript(true, "elementValue");
        elementCheckedJavaScript = ResourceContent.getScript(true, "elementChecked");
        searchShadowElementsJavaScript = ResourceContent.getScript(true, "searchShadowElements");
        htmlReportJavascript = ResourceContent.getScript("htmlreport/html-report");
        htmlReportTemplate = ResourceContent.getHtml("htmlreport/html-report");
        htmlReportActionHtmlTemplate = ResourceContent.getHtml("htmlreport/new-report-action");
        htmlReportCss = ResourceContent.getCss("htmlreport/html-report");
        htmlReportOneElementDataActionTemplate = ResourceContent.getHtml("htmlreport/1-tier-body-action");
        htmlReportTwoElementsDataActionTemplate = ResourceContent.getHtml("htmlreport/2-tier-body-action");
        htmlReportOneElementDataActionTemplate_AsaSuite = ResourceContent.getHtml("htmlreport/1-tier-body-action-asasuite");
        htmlReportTwoElementsDataActionTemplate_AsaSuite = ResourceContent.getHtml("htmlreport/2-tier-body-action-asasuite");
        htmlReportThreeElementsDataActionTemplate = ResourceContent.getHtml("htmlreport/3-tier-body-action");
        htmlReportApiCallActionTemplate = ResourceContent.getHtml("htmlreport/api-call-action-template");
        htmlReportPlaylistTemplate = ResourceContent.getHtml("htmlreport/playlist-template");
        htmlReportSuiteTemplate = ResourceContent.getHtml("htmlreport/new-suite-report");
        htmlReportExecutionTemplate = ResourceContent.getHtml("htmlreport/executions-template");
        htmlReportAssertPropertyActionTemplate = ResourceContent.getHtml("htmlreport/action-assert-property-template");
        htmlReportAssertOccurrenceActionTemplate = ResourceContent.getHtml("htmlreport/action-assert-occurrence-template");
        htmlReportAssertValueActionTemplate = ResourceContent.getHtml("htmlreport/action-assert-value-template");
        htmlReportSummaryTemplate = ResourceContent.getHtml("htmlreport/summary");
        htmlReportSummarySuiteTemplate = ResourceContent.getHtml("htmlreport/summarySuite");
        htmlReportSummaryTestCaseTemplate = ResourceContent.getHtml("htmlreport/summaryTestCase");
        htmlReportFooter = ResourceContent.getHtml("htmlreport/footer");
        atsLogo = Base64.getEncoder().encodeToString(ResourceContent.getAtsByteLogo());
        pageStyle = ResourceContent.getData("jsStyle");
    }
}

