/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.performance.proxy;

import com.ats.AtsSingleton;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.generator.ATS;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.network.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.performance.external.OctoperfApi;
import com.ats.tools.performance.filters.BlackListFilter;
import com.ats.tools.performance.filters.PausedListFilter;
import com.ats.tools.performance.filters.UrlBaseFilter;
import com.ats.tools.performance.filters.WhiteListFilter;
import com.ats.tools.performance.proxy.AtsBrowserMobProxyServer;
import com.ats.tools.performance.proxy.IAtsProxy;
import com.browserup.bup.BrowserUpProxy;
import com.browserup.bup.client.ClientUtil;
import com.browserup.bup.proxy.CaptureType;
import com.browserup.harreader.model.Har;
import com.browserup.harreader.model.HarEntry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openqa.selenium.Proxy;

public class AtsProxy
implements IAtsProxy {
    public static final String CHANNEL_STARTED_PAGEID = "ats-channel-start";
    private static final String TARGET_CAPTURE_FOLDER = "network-capture";
    private ProxyThread proxyThread;
    private ArrayList<HarEntry> harEntries = new ArrayList();
    private Path currentFile = null;
    private Path targetFolder = null;
    private OctoperfApi octoperf;
    private boolean terminated = false;

    public AtsProxy(ActionChannelStart actionStart, String channelName, String application, ArrayList<String> blacklist, int trafficIdle, OctoperfApi octoperf) {
        this.octoperf = octoperf;
        String uuid = UUID.randomUUID().toString();
        actionStart.setUuid(uuid);
        this.targetFolder = Paths.get("target", TARGET_CAPTURE_FOLDER, channelName).toAbsolutePath();
        if (!Files.exists(this.targetFolder, new LinkOption[0])) {
            this.targetFolder.toFile().mkdirs();
        }
        this.currentFile = this.targetFolder.resolve(uuid + ".har");
        AtsSingleton.getInstance().getLogger().sendInfo("start HAR proxy thread for channel", channelName);
        this.proxyThread = new ProxyThread(this, blacklist, trafficIdle, application, channelName);
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean value) {
        this.terminated = value;
        if (value) {
            AtsSingleton.getInstance().getLogger().sendInfo("terminate HAR proxy thread", this.currentFile.toString());
        }
    }

    @Override
    public void terminate(String channelName) {
        this.proxyThread.stop();
        this.proxyThread = null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isAutoDetect() {
        return false;
    }

    @Override
    public Proxy getValue() {
        new Thread((Runnable)this.proxyThread, "atsProxyThread").start();
        for (int maxTry = 30; this.proxyThread.getProxy() == null && maxTry > 0; --maxTry) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.proxyThread.getProxy();
    }

    @Override
    public void startRecord(ActionStatus status, List<String> whiteList, int trafficIddle, int latency, long sendBandWidth, long receiveBandWidth) {
        this.proxyThread.start(whiteList, trafficIddle, latency, sendBandWidth, receiveBandWidth);
    }

    @Override
    public void pauseRecord() {
        this.proxyThread.setPaused(true);
    }

    @Override
    public void resumeRecord() {
        this.proxyThread.setPaused(false);
    }

    @Override
    public void startAction(Action action, String testLine, String uid) {
        this.proxyThread.startAction(uid, action.getClass().getSimpleName() + testLine);
    }

    @Override
    public void endAction() {
        this.proxyThread.endAction();
    }

    @Override
    public void sendToOctoperfServer(Channel channel, ActionOctoperfVirtualUser action) {
    }

    private class ProxyThread
    implements Runnable {
        private AtsProxy atsProxy;
        private List<String> blacklistUrls;
        private List<String> whitelistUrls;
        private UrlBaseFilter currentUrlFilter;
        private boolean running = true;
        private boolean paused = false;
        private AtsBrowserMobProxyServer server;
        private Proxy proxy;

        public ProxyThread(AtsProxy atsProxy2, ArrayList<String> blacklist, int trafficIddle, String application, String channelName) {
            this.atsProxy = atsProxy2;
            this.server = new AtsBrowserMobProxyServer(trafficIddle);
            this.blacklistUrls = blacklist;
            this.selectFilter();
            this.startNewHar(AtsProxy.CHANNEL_STARTED_PAGEID);
        }

        private void selectFilter() {
            this.currentUrlFilter = this.paused ? new PausedListFilter() : (this.whitelistUrls != null && this.whitelistUrls.size() > 0 ? new WhiteListFilter(this.whitelistUrls) : (this.blacklistUrls != null && this.blacklistUrls.size() > 0 ? new BlackListFilter(this.blacklistUrls) : new UrlBaseFilter()));
        }

        @Override
        public void run() {
            this.server.start(0);
            this.proxy = ClientUtil.createSeleniumProxy((BrowserUpProxy)this.server);
            while (this.running) {
                Thread.yield();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.server.stop();
            this.terminate();
            Thread.currentThread().interrupt();
            this.atsProxy.setTerminated(true);
        }

        public Proxy getProxy() {
            return this.proxy;
        }

        public void stop() {
            this.running = false;
        }

        public void start(List<String> whiteList, int trafficIddle, int latency, long sendBandWidth, long receiveBandWidth) {
            this.server.setTrafficIddle(trafficIddle);
            this.server.setLatency(latency);
            this.server.setMaxUpload(sendBandWidth);
            this.server.setMaxDownload(receiveBandWidth);
            this.whitelistUrls = whiteList;
            this.selectFilter();
        }

        public void startNewHar(String newPageId) {
            this.server.newHar(newPageId, "ATS channel");
            this.server.setHarCaptureTypes(new CaptureType[]{CaptureType.REQUEST_HEADERS, CaptureType.REQUEST_CONTENT, CaptureType.RESPONSE_HEADERS, CaptureType.RESPONSE_COOKIES, CaptureType.REQUEST_COOKIES});
            this.server.getCurrentHarPage().setComment("new har capture");
            AtsProxy.this.harEntries = new ArrayList();
            this.currentUrlFilter.filter(this.server.getHar().getLog().getEntries(), AtsProxy.this.harEntries);
        }

        public void setPaused(boolean value) {
            this.paused = value;
            this.selectFilter();
        }

        public boolean terminate() {
            boolean bl;
            this.running = false;
            Har har = this.server.getHar();
            this.currentUrlFilter.filter(this.server.getHar().getLog().getEntries(), AtsProxy.this.harEntries);
            this.server.endHar();
            har.getLog().getCreator().setName("ats-automation");
            har.getLog().getCreator().setVersion(ATS.getAtsVersion());
            har.getLog().getEntries().addAll(AtsProxy.this.harEntries);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileWriter writer = new FileWriter(AtsProxy.this.currentFile.toFile());
            try {
                gson.toJson((Object)har, (Appendable)writer);
                writer.close();
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            writer.close();
            return bl;
        }

        public void startAction(String uid, String simpleName) {
            if (this.server.getHar() != null) {
                this.server.startTrafficListener();
                this.server.endPage();
                this.currentUrlFilter.filter(this.server.getHar().getLog().getEntries(), AtsProxy.this.harEntries);
                this.currentUrlFilter.setPageId(uid);
                this.server.newPage(uid, simpleName);
                this.server.getCurrentHarPage().setComment(uid);
            }
        }

        public void endAction() {
            this.server.waitTrafficFinished();
        }
    }
}

