/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.driver.AtsManager;
import com.ats.tools.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.w3c.dom.DOMException;

public class PrepareProjectExecution {
    public static void main(String[] args) throws DOMException, Exception {
        Path pomFilePath;
        String targetFolder = "target";
        if (args.length > 0) {
            targetFolder = args[0];
        }
        if ((pomFilePath = Paths.get("pom.xml", new String[0])).toAbsolutePath().toFile().exists()) {
            try {
                Path targetPath = Paths.get(targetFolder, new String[0]);
                File targetFile = targetPath.toFile();
                if (targetFile.exists()) {
                    try {
                        Utils.deleteRecursiveFiles(targetFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    targetFile.mkdir();
                }
                File buildFile = targetPath.resolve("build.xml").toFile();
                FileWriter fw = new FileWriter(buildFile);
                fw.write("<project basedir=\".\" default=\"compile\">");
                fw.write("<copy todir=\"classes\"> ");
                fw.write("<fileset dir=\"..\\src\" includes='assets/**'/>");
                fw.write("</copy>");
                fw.write("<property name=\"lib.dir\" value=\"lib\"/>");
                fw.write("<path id=\"classpath\">");
                fw.write("<fileset dir=\"" + AtsManager.getAtsHomeFolder() + "\\libs\" includes=\"**/*.jar\"/>");
                fw.write("</path>");
                fw.write("<target name=\"compile\">");
                fw.write("<mkdir dir=\"classes\"/>");
                fw.write("<javac srcdir=\"generated\" destdir=\"classes\" classpathref=\"classpath\"/>");
                fw.write("</target>");
                fw.write("</project>");
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

