/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions;

import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.OperatorsWithIcons;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportActionChannel {
    private static final String APPLICATION_ICON_TEMPLATE = "<img loading=\"lazy\" style=\"margin-right: 10px\" src=\"data:image/png;base64,${appIcon}\" alt=\"Application icon\">";
    private static final String OS_INFO_SECTION_TEMPLATE = "<div style=\"display: flex; align-items: center;\">\n    <div class=\"${osIcon}\"></div>\n    ${osInfo}\n</div>";
    private static final String APPLICATION_TEMPLATE = "<div style=\"display: flex; flex-direction: column; justify-content: space-evenly; height: 100%;\">\n    ${osInfoTemplate}\n    <div style=\"display: flex; align-items: center;\">\n        ${appIconTemplate}\n        ${appName}\n    </div>\n</div>";
    private static final String SWITCH_CHANNEL_HTML_TEMPLATE = "<div>${oldChannel}</div>${operator}<div>${newChannel}</div>";
    private static final String VERSION_TEMPLATE = "<div style=\"display: flex; flex-direction: column; justify-content: space-evenly; height: 100%;\">\n    <div>${osVersion}</div>\n    <div>${appVersion}</div>\n</div>";
    private String result;

    public HtmlReportActionChannel(String template, Action action, ActionChannelOperation actionChannelOperation, Map<String, String> appIcons) {
        if (ActionChannelOperation.CHANNEL_CHANGE.equals((Object)actionChannelOperation)) {
            this.result = template.replace("${header1}", "Switch channel");
            this.result = this.result.replace("${value1}", Objects.nonNull(action.getChannel()) ? this.buildSwitchChannelString(action) : "");
        } else {
            this.result = template.replace("${header1}", "Channel name");
            this.result = this.result.replace("${header2}", "Application");
            if (actionChannelOperation.equals((Object)ActionChannelOperation.CHANNEL_START)) {
                this.result = this.result.replace("${header3}", "Version");
            }
            if (Objects.nonNull(action.getAppDataJson()) && Objects.nonNull(action.getChannel())) {
                String appIcon = appIcons.get(action.getAppDataJson().getApp());
                String applicationName = APPLICATION_TEMPLATE.replace("${appName}", action.getAppDataJson().getApp());
                String version = "";
                String osName = OS_INFO_SECTION_TEMPLATE;
                if (ActionChannelOperation.CHANNEL_START.equals((Object)actionChannelOperation)) {
                    String os = action.getAppDataJson().getOs();
                    OperatingSystem operatingSystem = OperatingSystem.fromName(os);
                    if (Objects.nonNull((Object)operatingSystem)) {
                        osName = osName.replace("${osInfo}", operatingSystem.getName());
                        osName = osName.replace("${osIcon}", operatingSystem.getIconClass());
                        applicationName = applicationName.replace("${osInfoTemplate}", osName);
                        version = VERSION_TEMPLATE.replace("${osVersion}", os);
                    } else {
                        applicationName = applicationName.replace("${osInfoTemplate}", "");
                    }
                    this.result = this.result.replace("${value3}", version.replace("${appVersion}", StringUtils.isBlank((CharSequence)action.getAppDataJson().getAppVersion()) ? "" : action.getAppDataJson().getAppVersion()));
                } else {
                    applicationName = applicationName.replace("${osInfoTemplate}", "");
                }
                applicationName = applicationName.replace("${appIconTemplate}", StringUtils.isBlank((CharSequence)appIcon) ? "" : APPLICATION_ICON_TEMPLATE.replace("${appIcon}", appIcon));
                this.result = this.result.replace("${value1}", action.getAppDataJson().getName());
                this.result = this.result.replace("${value2}", applicationName);
            } else {
                this.result = this.result.replace("${value1}", "");
                this.result = this.result.replace("${value2}", "");
                if (actionChannelOperation.equals((Object)ActionChannelOperation.CHANNEL_START)) {
                    this.result = this.result.replace("${value3}", "");
                }
            }
        }
    }

    private CharSequence buildSwitchChannelString(Action action) {
        return SWITCH_CHANNEL_HTML_TEMPLATE.replace("${oldChannel}", action.getChannel().getName()).replace("${newChannel}", action.getValue()).replace("${operator}", OperatorsWithIcons.getIconForOperator("ARROW"));
    }

    public String getResult() {
        return this.result;
    }

    public static enum ActionChannelOperation {
        CHANNEL_START,
        CHANNEL_CLOSE,
        CHANNEL_CHANGE;

    }

    private static enum OperatingSystem {
        WINDOWS(Set.of("windows", "microsoft"), "Windows", "windows-icon"),
        LINUX(Set.of("linux"), "Linux", "linux-icon"),
        MACOS(Set.of("macos"), "Macos", "macos-icon");

        private final Set<String> nameKeywords;
        private final String name;
        private final String iconClass;

        private OperatingSystem(Set<String> nameKeywords, String name, String iconClass) {
            this.nameKeywords = nameKeywords;
            this.name = name;
            this.iconClass = iconClass;
        }

        public Set<String> getNameKeywords() {
            return this.nameKeywords;
        }

        public String getName() {
            return this.name;
        }

        public String getIconClass() {
            return this.iconClass;
        }

        public static OperatingSystem fromName(String name) {
            return StringUtils.isBlank((CharSequence)name) ? null : (OperatingSystem)Stream.of(OperatingSystem.values()).filter(os -> os.getNameKeywords().stream().anyMatch(keyword -> name.toLowerCase().contains((CharSequence)keyword))).findFirst().orElse(null);
        }
    }
}

