/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.utils.HtmlActionUtils;
import com.ats.tools.report.utils.HtmlReportActionKeyValueTemplate;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportActionDownload {
    private String result;

    public HtmlReportActionDownload(String template, Action action) {
        this.result = template.replace("${header1}", HtmlActionUtils.buildHtmlHeader("Download data", action.getError()));
        this.result = this.result.replace("${header2}", HtmlActionUtils.buildSearchedElementHeader(action));
        DownloadFile downloadFile = this.parseFileData(action);
        LinkedHashMap<String, String> downloadData = new LinkedHashMap<String, String>();
        downloadData.put("URL", Optional.ofNullable(action.getValue()).filter(StringUtils::isNotBlank).map(HtmlActionUtils::buildLink).orElse(""));
        downloadData.put("Folder", (String)StringUtils.defaultIfBlank((CharSequence)downloadFile.file(), (CharSequence)""));
        downloadData.put("File Size", String.format("%d bytes", downloadFile.fileSize()));
        this.result = this.result.replace("${value1}", HtmlReportActionKeyValueTemplate.buildLabelValueString(downloadData, true));
        this.result = this.result.replace("${value2}", Objects.nonNull(action.getActionElement()) ? HtmlActionUtils.buildSearchedElementData(action) : "");
    }

    public String getResult() {
        return this.result;
    }

    private DownloadFile parseFileData(Action action) {
        DownloadFile downloadFile = new DownloadFile("", 0L);
        if (StringUtils.isBlank((CharSequence)action.getData())) {
            return downloadFile;
        }
        try {
            return (DownloadFile)new Gson().fromJson(action.getData(), DownloadFile.class);
        }
        catch (JsonSyntaxException e) {
            AtsLogger.printLog(String.format("script: %s; line: %d", action.getScript(), action.getLine()), "cannot parse download data");
            return downloadFile;
        }
    }

    public record DownloadFile(String file, long fileSize) {
    }
}

