/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions;

import com.ats.tools.report.models.Action;
import com.ats.tools.report.utils.HtmlActionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportActionFileTransfer {
    private static final String FAIL_UPLOAD_ICON_CLASS = "file-upload-icon-fail";
    private static final String FAIL_UPLOAD_ICON_TITLE = "File not found!";
    private static final String PASS_UPLOAD_ICON_CLASS = "file-upload-icon-success";
    private static final String PASS_UPLOAD_ICON_TITLE = "File found";
    private static final String FILE_TEMPLATE = "<div style=\"display: flex;\" title=\"%s\" aria-label=\"%s\">\n    <div class=\"%s\"></div>\n    <div style=\"margin-left: 7px;\">%s</div>\n</div>";
    private String result;

    public HtmlReportActionFileTransfer(String template, Action action) {
        String foundFilesString = Objects.requireNonNullElse(action.getValue(), "");
        String notFoundFilesString = Objects.requireNonNullElse(action.getData(), "");
        List<String> foundFiles = Stream.of(foundFilesString.split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(file -> String.format(FILE_TEMPLATE, PASS_UPLOAD_ICON_TITLE, PASS_UPLOAD_ICON_TITLE, PASS_UPLOAD_ICON_CLASS, file)).toList();
        List<String> notFoundFiles = Stream.of(notFoundFilesString.split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(file -> String.format(FILE_TEMPLATE, FAIL_UPLOAD_ICON_TITLE, PASS_UPLOAD_ICON_TITLE, FAIL_UPLOAD_ICON_CLASS, file)).toList();
        this.result = template.replace("${header1}", HtmlActionUtils.buildHtmlHeader(String.format("Uploaded file%s", foundFiles.size() + notFoundFiles.size() > 1 ? "s" : ""), action.getError()));
        this.result = this.result.replace("${header2}", HtmlActionUtils.buildSearchedElementHeader(action));
        String filesHtml = Stream.of(foundFiles, notFoundFiles).flatMap(Collection::stream).collect(Collectors.joining("", "<div>", "</div>"));
        this.result = this.result.replace("${value1}", filesHtml);
        this.result = Objects.nonNull(action.getActionElement()) ? this.result.replace("${value2}", HtmlActionUtils.buildSearchedElementData(action)) : this.result.replace("${value2}", "");
    }

    public String getResult() {
        return this.result;
    }
}

