/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions.callscript;

import com.ats.tools.report.actions.callscript.ActionCallscriptData;
import com.ats.tools.report.actions.callscript.AssetFileActionCallscriptData;
import com.ats.tools.report.actions.callscript.ErrorTagFileActionCallscriptDataDecorator;
import com.ats.tools.report.actions.callscript.LocalFileActionCallscriptData;
import com.ats.tools.report.actions.callscript.ParameterActionCallscriptData;
import com.ats.tools.report.actions.callscript.ParametersActionCallscriptData;
import com.ats.tools.report.actions.callscript.RemoteFileActionCallscriptData;
import com.ats.tools.report.actions.callscript.SearchedElementActionCallscriptData;
import com.ats.tools.report.actions.callscript.SearchedElementData;
import com.ats.tools.report.actions.callscript.TablePatametersActionCallscriptData;
import com.ats.tools.report.models.Action;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ActionCallscriptDataJsonDeserializer
implements JsonDeserializer<ActionCallscriptData> {
    private static final String LOCAL_FILE_DATA_TYPE = "local-file";
    private static final String REMOTE_FILE_DATA_TYPE = "remote-file";
    private static final String ASSET_FILE_DATA_TYPE = "asset-file";
    private static final String PARAMETERS_DATA_TYPE = "parameters";
    private static final String TABLE_DATA_TYPE = "table";
    private static final String ELEMENT_DATA_TYPE = "element";
    private final String projectId;
    private final Action action;

    public ActionCallscriptDataJsonDeserializer(String projectId, Action action) {
        this.projectId = projectId;
        this.action = action;
    }

    public ActionCallscriptData deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String dataType = (String)((Map.Entry)jsonObject.entrySet().iterator().next()).getKey();
        JsonElement data = jsonObject.get(dataType);
        return switch (dataType) {
            case LOCAL_FILE_DATA_TYPE -> new ErrorTagFileActionCallscriptDataDecorator(new LocalFileActionCallscriptData(data.getAsString()), this.action.getError());
            case REMOTE_FILE_DATA_TYPE -> new ErrorTagFileActionCallscriptDataDecorator(new RemoteFileActionCallscriptData(data.getAsString()), this.action.getError());
            case ASSET_FILE_DATA_TYPE -> new ErrorTagFileActionCallscriptDataDecorator(new AssetFileActionCallscriptData(data.getAsString(), this.projectId), this.action.getError());
            case PARAMETERS_DATA_TYPE -> new ParametersActionCallscriptData((List)context.deserialize(data, new TypeToken<List<ParameterActionCallscriptData>>(){}.getType()));
            case TABLE_DATA_TYPE -> new TablePatametersActionCallscriptData((List)context.deserialize(data, new TypeToken<List<Map<String, Map<String, String>>>>(){}.getType()));
            case ELEMENT_DATA_TYPE -> new SearchedElementActionCallscriptData((SearchedElementData)context.deserialize(data, SearchedElementData.class), this.action);
            default -> throw new IllegalArgumentException("unknown callscript input data type: " + dataType);
        };
    }
}

