/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.adapters;

import com.ats.tools.report.Constants;
import com.ats.tools.report.adapters.ReportAdapter;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.SuiteInfo;
import com.ats.tools.report.models.TestSummary;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class PassContinueReportAdapter
implements ReportAdapter {
    @Override
    public void apply(HtmlReportProject project, Results results, List<TestSummary> testSummaries, List<Script> scripts) {
        this.updateResultAndScriptsBasedOnTestSummaries(testSummaries, results, scripts);
    }

    protected void updateResultAndScriptsBasedOnTestSummaries(List<TestSummary> testSummaries, Results results, List<Script> scripts) {
        testSummaries.stream().filter(summary -> Constants.SummaryStatus.PASS_CONTINUE.getNumericValue().equals(summary.getStatus())).forEach(summary -> {
            List<Script> suiteScripts = scripts.stream().filter(script -> summary.getSuiteName().equals(script.getSuite())).toList();
            suiteScripts.stream().filter(script -> summary.getTestName().equals(script.getName()) && !script.isPassed()).findFirst().ifPresent(script -> script.setPassed(Constants.Status.PASS.getBooleanValue()));
            results.getSuites().stream().filter(suiteInfo -> summary.getSuiteName().equals(suiteInfo.getName())).findFirst().ifPresent(suiteInfo -> {
                Map<Boolean, List<Script>> scriptsByStatus = suiteScripts.stream().collect(Collectors.groupingBy(Script::isPassed));
                suiteInfo.setTestsPassed(CollectionUtils.emptyIfNull((Collection)scriptsByStatus.get(Constants.Status.PASS.getBooleanValue())).size());
                suiteInfo.setTestsFailed(CollectionUtils.emptyIfNull((Collection)scriptsByStatus.get(Constants.Status.FAIL.getBooleanValue())).size());
                suiteInfo.setStatus(suiteInfo.getTestsFailed() > 0 ? Constants.Status.FAIL.getValue() : Constants.Status.PASS.getValue());
            });
        });
        Map<String, List<SuiteInfo>> suitesByStatus = results.getSuites().stream().collect(Collectors.groupingBy(SuiteInfo::getStatus));
        results.setSuitesFailed(CollectionUtils.emptyIfNull((Collection)suitesByStatus.get(Constants.Status.FAIL.getValue())).size());
        results.setSuitesPassed(CollectionUtils.emptyIfNull((Collection)suitesByStatus.get(Constants.Status.PASS.getValue())).size());
        results.setStatus(results.getSuitesFailed() > 0 ? Constants.Status.FAIL.getValue() : Constants.Status.PASS.getValue());
    }
}

