/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.atsv;

import com.ats.executor.TestBound;
import com.ats.flex.messaging.amf.io.AMF3Deserializer;
import com.ats.recorder.TestError;
import com.ats.recorder.TestSummary;
import com.ats.recorder.VisualAction;
import com.ats.recorder.VisualElement;
import com.ats.recorder.VisualReport;
import com.ats.tools.ResourceContent;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.report.atsv.models.ActionData;
import com.ats.tools.report.atsv.models.BoundData;
import com.ats.tools.report.atsv.models.ChannelData;
import com.ats.tools.report.atsv.models.ElementData;
import com.ats.tools.report.atsv.models.ElementExtraData;
import com.ats.tools.report.atsv.models.ExecutionData;
import com.ats.tools.report.atsv.models.ImageData;
import com.ats.tools.report.atsv.models.ReportData;
import com.ats.tools.report.atsv.models.TestData;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class HtmlPlayerReportReader {
    private static final String REPORT_FOLDER = "reports";
    private static final Path reportPath = Paths.get("src", "assets", "resources", "reports");
    private static final Path imagesPath = Paths.get(reportPath.toString(), "images");
    private static final String[] imagesList = new String[]{"logo.png", "true.png", "false.png", "warning.png", "noStop.png", "api.png", "pdf.png", "watermark-player.png"};
    private static final String IMAGE_FOLDER = "images";
    private static final String CUSTOM_IMAGES_FOLDER = "/reports/images/";
    private final ExecutionLogger logger;

    public HtmlPlayerReportReader(ExecutionLogger logger) {
        this.logger = logger;
    }

    public ReportData readReportDate(Path atsvFile) throws IOException {
        try (AMF3Deserializer amf3 = new AMF3Deserializer(Files.newInputStream(atsvFile, new OpenOption[0]));){
            VisualReport report = (VisualReport)amf3.readObject();
            ExecutionData executionData = this.readReportExecutionData(report);
            TestData testData = null;
            this.skipStartScriptAction(amf3);
            ArrayList<ActionData> actionsData = new ArrayList<ActionData>();
            while (amf3.available() > 0) {
                Object obj = amf3.readObject();
                if (obj instanceof VisualAction) {
                    VisualAction va = (VisualAction)obj;
                    ElementData element = null;
                    if (Objects.nonNull(va.getElement())) {
                        element = this.readElementData(va.getElement());
                    }
                    ImageData images = this.readImageData(va);
                    actionsData.add(this.readActionData(va, element, images));
                    continue;
                }
                if (!(obj instanceof TestSummary)) continue;
                TestSummary reportSummary = (TestSummary)obj;
                testData = this.readReportTestData(report, reportSummary);
            }
            Map<String, String> playerReportImages = this.readImages();
            Map<String, Map<String, String>> icons = Stream.concat(this.extractFolderIcons("png").entrySet().stream(), this.extractFolderIcons("gif").entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
                v1.putAll(v2);
                return v1;
            }));
            ReportData reportData = new ReportData(executionData, testData, actionsData, playerReportImages, icons);
            return reportData;
        }
    }

    private void skipStartScriptAction(AMF3Deserializer amf3) throws IOException {
        amf3.readObject();
    }

    private Map<String, String> readImages() {
        HashMap<String, String> images = new HashMap<String, String>();
        if (Files.exists(imagesPath, new LinkOption[0])) {
            for (String img : imagesList) {
                Path imagePath = imagesPath.resolve(img);
                if (!Files.exists(imagePath, new LinkOption[0])) continue;
                if (Files.isRegularFile(imagePath, new LinkOption[0])) {
                    String fileNameWithExtension = imagePath.getFileName().toString();
                    String fileName = fileNameWithExtension.substring(0, fileNameWithExtension.lastIndexOf("."));
                    String imgData = this.getImgInBase64(imagePath.getParent(), fileNameWithExtension);
                    images.put(fileName.replaceAll("-", "_"), this.jsData(imgData));
                    continue;
                }
                this.logger.sendInfo("path is not a file", imagePath.toString());
            }
        } else {
            this.logger.sendInfo("No image folder found", imagesPath.toString());
        }
        return images;
    }

    private String getImgInBase64(Path path, String imgFileName) {
        String imgFile;
        String format = imgFileName.substring(imgFileName.lastIndexOf(".") + 1);
        if (Files.exists(path.resolve(imgFileName), new LinkOption[0])) {
            try {
                byte[] imgBytes = Files.readAllBytes(path.resolve(imgFileName));
                imgFile = "data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(imgBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            byte[] imgBytes = Objects.requireNonNull(ResourceContent.class.getResourceAsStream(CUSTOM_IMAGES_FOLDER + imgFileName)).readAllBytes();
            imgFile = "data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(imgBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return imgFile;
    }

    private Map<String, Map<String, String>> extractFolderIcons(String ext) {
        List<String> resourceToCopy = HtmlPlayerReportReader.extractJarFolderResourcesPath(ext);
        HashMap<String, Map<String, String>> iconsData = new HashMap<String, Map<String, String>>();
        while (!resourceToCopy.isEmpty()) {
            String subPath = resourceToCopy.getFirst().substring(0, resourceToCopy.getFirst().lastIndexOf("/"));
            int loopSize = resourceToCopy.size();
            int index = 0;
            HashMap<String, String> icons = new HashMap<String, String>();
            while (index < loopSize) {
                String path = resourceToCopy.get(index);
                String subPathData = path.substring(0, path.lastIndexOf("/"));
                if (subPathData.startsWith(subPath)) {
                    try {
                        byte[] imgBytes = Objects.requireNonNull(ResourceContent.class.getResourceAsStream("/" + path)).readAllBytes();
                        String fileName = path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf("."));
                        icons.put(fileName.replaceAll("/", "_").replaceAll("-", "_"), this.jsData("data:image/" + ext + ";base64," + Base64.getEncoder().encodeToString(imgBytes)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    resourceToCopy.remove(path);
                    --loopSize;
                    continue;
                }
                ++index;
            }
            String key = subPath.replace("reports/playerHTML/icons", "").substring(1).replaceAll("/", "_");
            iconsData.put(key, icons);
        }
        return iconsData;
    }

    private static List<String> extractJarFolderResourcesPath(String ext) {
        CodeSource src = ResourceContent.class.getProtectionDomain().getCodeSource();
        ArrayList<String> list = new ArrayList<String>();
        if (src != null) {
            ZipInputStream zip;
            URL jar = src.getLocation();
            try {
                zip = new ZipInputStream(jar.openStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            while (true) {
                ZipEntry ze;
                try {
                    ze = zip.getNextEntry();
                    if (ze == null) {
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String entryName = ze.getName();
                if (!entryName.startsWith("reports/playerHTML/icons") || !entryName.endsWith("." + ext)) continue;
                list.add(entryName);
            }
        }
        return list;
    }

    private ActionData readActionData(VisualAction va, ElementData element, ImageData images) {
        return new ActionData(Integer.parseInt(this.jsData(va.getIndex())), this.jsData(va.getType()), Integer.parseInt(this.jsData(va.getLine())), this.jsData(va.getScript()), Long.parseLong(this.jsData(va.getTimeLine())), this.jsData(va.getUuid()), Integer.parseInt(this.jsData(va.getError())), Integer.parseInt(this.jsData(va.isStop())), Integer.parseInt(this.jsData(va.getDuration())), Integer.parseInt(this.jsData(va.getError() == 0)), this.jsData(va.getValue()), this.jsData(va.getData()), this.readChannelData(va), element, images);
    }

    private ChannelData readChannelData(VisualAction va) {
        return new ChannelData(this.jsData(va.getChannelName()), this.readBoundData(va.getChannelBound()));
    }

    private ExecutionData readReportExecutionData(VisualReport report) {
        return new ExecutionData(Integer.parseInt(this.jsData(report.getCpuSpeed())), Integer.parseInt(this.jsData(report.getCpuCount())), Long.parseLong(this.jsData(report.getTotalMemory())), this.jsData(report.getOsInfo()));
    }

    private ElementData readElementData(VisualElement ve) {
        ElementExtraData extra = null;
        if (Objects.nonNull(ve.getHpos()) && Objects.nonNull(ve.getVpos())) {
            extra = new ElementExtraData(this.jsData(ve.getHpos()), Integer.parseInt(this.jsData(ve.getHposValue())), this.jsData(ve.getVpos()), Integer.parseInt(this.jsData(ve.getVposValue())));
        }
        return new ElementData(this.jsData(ve.getTag()), this.jsData(ve.getCriterias()), Integer.parseInt(this.jsData(ve.getFoundElements())), Long.parseLong(this.jsData(ve.getSearchDuration())), this.readBoundData(ve.getRectangle()), extra);
    }

    private BoundData readBoundData(TestBound bound) {
        return new BoundData(Integer.parseInt(this.jsData(bound.getX().intValue())), Integer.parseInt(this.jsData(bound.getY().intValue())), Integer.parseInt(this.jsData(bound.getWidth().intValue())), Integer.parseInt(this.jsData(bound.getHeight().intValue())));
    }

    private ImageData readImageData(VisualAction va) {
        ArrayList<byte[]> images = va.getImages();
        Map<Integer, String> encodedImages = IntStream.range(0, images.size()).boxed().collect(Collectors.toMap(Function.identity(), index -> this.jsData(Base64.getEncoder().encodeToString((byte[])images.get((int)index)))));
        return new ImageData(this.jsData(va.getImageType()), Integer.parseInt(this.jsData(images.size())), encodedImages);
    }

    private TestData readReportTestData(VisualReport report, TestSummary reportSummary) {
        String error = null;
        if (reportSummary.getStatus() == 0 && reportSummary.getError() != null) {
            TestError scriptError = reportSummary.getError();
            error = "{\nscript : " + this.jsData(scriptError.getScriptLine()) + ", line : " + this.jsData(scriptError.getLine()) + ", message : " + this.jsData(scriptError.getMessage()) + "\n}";
        }
        return new TestData(this.jsData(report.getId()), this.jsData(report.getScript()), this.jsData(report.getExternalId()), this.jsData(report.getDescription()), this.jsData(report.getAuthor()), this.jsData(report.getPrerequisite()), Long.parseLong(this.jsData(Long.valueOf(report.getStarted()))), Integer.parseInt(this.jsData(report.getQuality())), this.jsData(report.getGroups()), Integer.parseInt(this.jsData(reportSummary.getActions())), this.jsData(reportSummary.getSuiteName()), Integer.parseInt(this.jsData(reportSummary.getStatus())), this.jsData(reportSummary.getSummary()), error);
    }

    private String jsData(Object obj) {
        Object data;
        if (obj instanceof String) {
            Object tmp = (String)obj;
            if (((String)tmp).lastIndexOf("\\") != -1 && ((String)tmp).lastIndexOf("\\") == ((String)tmp).length() - 1) {
                tmp = ((String)tmp).substring(0, ((String)tmp).length() - 2) + "&#92;";
            }
            data = ((String)tmp).replaceAll("\"", "'");
        } else {
            data = obj instanceof Integer || obj instanceof Long ? String.valueOf(obj) : (obj instanceof Boolean ? ((Boolean)obj != false ? "1" : "0") : "");
        }
        return StandardCharsets.UTF_8.decode(StandardCharsets.UTF_8.encode((String)data)).toString();
    }
}

