/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.builders;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.Constants;
import com.ats.tools.report.models.ExecutionGroup;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class GroupTagBuilder {
    private static final String EXECUTION_GROUP_TOOLTIP_LINE = "    <div class=\"execution-group-tooltip-text\">\n        <div class=\"execution-group-tooltip-label\">${label}: </div>\n        <span>${text}</span>\n    </div>\n";
    private static final String EXECUTION_GROUP_NAME_HTML_TEMPLATE = "<a class=\"test-case-header-name-execution-group-link\" href=\"ats://${groupUri}\" target=\"_self\">\n    <div class=\"execution-group-tooltip-trigger\">\n        <div class=\"execution-group-tooltip-wrapper\">\n            <div style=\"background-color: ${backgroundColor}; border: 2px solid ${color}; color: ${color};\"\n             class=\"test-case-header-name-execution-group-link-text\">\n                ${executionGroupTag}\n            </div>\n        </div>\n        ${warningIcon}\n        <div class=\"execution-group-tooltip\">\n            ${tooltipContent}\n        </div>\n    </div>\n</a>";
    private static final String GROUP_NAME_HTML_TEMPLATE = "<a class=\"item-with-frame\" style=\"text-decoration: none; color: rgba(56, 63, 79, 1); display: flex;\" href=\"ats://${groupUri}\" target=\"_self\">\n    <div class=\"external-link-icon\"></div>${groupName}\n</a>";

    private GroupTagBuilder() {
    }

    public static String buildExecutionGroupTagWithLink(Map<String, ExecutionGroup> executionGroups, String group, String projectId) {
        String warningIcon;
        String groupDescriptionLine;
        String groupNameLine;
        Constants.ExecutionGroupStyle executionGroupStyle;
        String tag;
        ExecutionGroup executionGroup = executionGroups.get(group);
        if (Objects.nonNull(executionGroup)) {
            tag = executionGroup.tag();
            executionGroupStyle = Constants.EXECUTION_GROUPS_STYLE.get(executionGroup.color());
            groupNameLine = EXECUTION_GROUP_TOOLTIP_LINE.replace("${label}", "Group").replace("${text}", executionGroup.name());
            groupDescriptionLine = "";
            if (StringUtils.isNotBlank((CharSequence)executionGroup.description())) {
                groupDescriptionLine = EXECUTION_GROUP_TOOLTIP_LINE.replace("${label}", "Description").replace("${text}", executionGroup.description());
            }
            warningIcon = "";
        } else {
            AtsLogger.printLog(String.format("non existent execution group detected - %s", group));
            AtsLogger.printLog(String.format("loaded execution groups - %s", executionGroups.values().stream().map(ExecutionGroup::toString).collect(Collectors.joining(";"))));
            tag = "<span class=\"strike\">\n    <span class=\"through\" style=\"background: black\"></span>\n    ${tag}\n</span>".replace("${tag}", (group.length() > 3 ? group.substring(0, 3) : group).toUpperCase());
            executionGroupStyle = Constants.DEFAULT_GROUP_STYLE;
            groupNameLine = EXECUTION_GROUP_TOOLTIP_LINE.replace("${label}", "Group").replace("${text}", group);
            groupDescriptionLine = "<div class=\"execution-group-tooltip-text\">\n    <div style=\"color: #DAA520;\">Group does not exist in .atsProjectProperties file!</div>\n</div>";
            warningIcon = "<div style='font-size: 12px; position: relative; right: 6px; bottom: 9px;'>\u26a0\ufe0f</div>";
        }
        return EXECUTION_GROUP_NAME_HTML_TEMPLATE.replace("${groupUri}", String.format("%s/group/%s", projectId, group)).replace("${backgroundColor}", executionGroupStyle.backgroundColor()).replace("${color}", executionGroupStyle.textColor()).replace("${warningIcon}", warningIcon).replace("${tooltipContent}", String.join((CharSequence)"", groupNameLine, groupDescriptionLine)).replace("${executionGroupTag}", tag);
    }

    public static String buildGroupNameWithLink(String projectId, String group) {
        return GROUP_NAME_HTML_TEMPLATE.replace("${groupUri}", String.format("%s/group/%s", projectId, group)).replace("${groupName}", group);
    }
}

