/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.context.reader;

import com.ats.tools.report.adapters.FailPassFilterReportAdapter;
import com.ats.tools.report.adapters.ReportAdapter;
import com.ats.tools.report.context.reader.AbstractReportContextExecutionReader;
import com.ats.tools.report.context.reader.FailPassReportContextExecutionAware;
import com.ats.tools.report.context.reader.FullReportContextExecutionReader;
import com.ats.tools.report.context.reader.ReportContextExecutionReader;
import com.ats.tools.report.models.Properties;
import com.ats.tools.report.models.ReportContextExecution;
import com.ats.tools.report.models.ReportFileNames;
import com.ats.tools.report.models.ReportItem;
import com.ats.tools.report.models.ReportSettings;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.TestSummary;
import com.ats.tools.report.summary.SummaryCalculator;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class FailPassReportContextExecutionReaderDecorator
implements ReportContextExecutionReader,
FailPassReportContextExecutionAware {
    private final FullReportContextExecutionReader reader;

    public FailPassReportContextExecutionReaderDecorator(FullReportContextExecutionReader reader) {
        this.reader = reader;
    }

    @Override
    public ReportContextExecution getPassContextExecution() throws Exception {
        return new FailPassReportContextExecutionFilterReader(this, this.reader, "-pass", new FailPassFilterReportAdapter(true), this.reader.getSummaryCalculator(), this.reader.getReportSettings(), this.reader.getSuiteItem()).getReportContextExecution();
    }

    @Override
    public ReportContextExecution getFailContextExecution() throws Exception {
        return new FailPassReportContextExecutionFilterReader(this, this.reader, "-fail", new FailPassFilterReportAdapter(false), this.reader.getSummaryCalculator(), this.reader.getReportSettings(), this.reader.getSuiteItem()).getReportContextExecution();
    }

    @Override
    public ReportContextExecution getReportContextExecution() throws Exception {
        return this.reader.getReportContextExecution();
    }

    private class FailPassReportContextExecutionFilterReader
    extends AbstractReportContextExecutionReader {
        private final FullReportContextExecutionReader reader;
        private final String reportNameSuffix;

        protected FailPassReportContextExecutionFilterReader(FailPassReportContextExecutionReaderDecorator failPassReportContextExecutionReaderDecorator, FullReportContextExecutionReader reader, String reportNameSuffix, ReportAdapter reportAdapter, SummaryCalculator summaryCalculator, ReportSettings reportSettings, ReportItem suiteItem) {
            super(reportAdapter, summaryCalculator, reportSettings, suiteItem);
            this.reader = reader;
            this.reportNameSuffix = reportNameSuffix;
        }

        @Override
        void readFiles() {
            this.setScripts(new ArrayList<Script>(this.reader.getScripts()));
            this.setProject(this.reader.getProject().deepCopy());
            this.setResults(this.reader.getResults().deepCopy());
            this.setTestSummaries(this.reader.getTestSummaries().stream().map(TestSummary::deepCopy).collect(Collectors.toList()));
        }

        @Override
        Properties readProjectProperties() {
            return this.reader.getProject().getProperties();
        }

        @Override
        public ReportContextExecution getReportContextExecution() throws Exception {
            ReportContextExecution contextExecution = super.getReportContextExecution();
            ReportSettings reportSettings = contextExecution.reportSettings().withNewValidationAndSplitReport(false, false);
            ReportFileNames fileNames = new ReportFileNames("ats-report.html".replace("ats-report", "ats-report" + this.reportNameSuffix), "", "summary.html", "");
            return contextExecution.withNewReportFileNamesAndReportFileNames(reportSettings, fileNames);
        }
    }
}

