/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.generators;

import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.report.generators.HtmlPlayerReportGenerator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class HtmlPlayerReportGeneratorCli {
    private static final String TEST_PROJECT_OUTPUT_FOLDER = "target/ats-output";
    private final Options options;
    private final Option atsvFile = Option.builder((String)"atsv-file").longOpt("atsv-file").hasArg().required().desc("relative path to atsv file from target/ats-output folder").build();
    private final String[] args;
    private final ExecutionLogger logger;

    public HtmlPlayerReportGeneratorCli(String[] args) {
        this.args = args;
        this.options = new Options();
        this.options.addOption(this.atsvFile);
        this.logger = new ExecutionLogger(System.out, "info", "");
    }

    public static void main(String[] args) {
        HtmlPlayerReportGeneratorCli generator = new HtmlPlayerReportGeneratorCli(args);
        generator.generate();
    }

    public void generate() {
        this.logger.sendInfo("ATSV CLI report generation", "start");
        String atsvFile = "";
        try {
            atsvFile = this.parseArg();
        }
        catch (IllegalArgumentException | ParseException e) {
            this.logger.sendError("ATSV CLI report generation", e.getMessage());
            return;
        }
        this.logger.sendInfo("ATSV file path", atsvFile);
        Path atsvFilePath = Paths.get("", new String[0]).toAbsolutePath().resolve(TEST_PROJECT_OUTPUT_FOLDER).resolve(atsvFile);
        this.logger.sendInfo("ATSV file absolute path", atsvFilePath.toString());
        String fileNameWithExtension = atsvFilePath.getFileName().toString();
        String fileName = fileNameWithExtension.substring(0, fileNameWithExtension.lastIndexOf("."));
        new HtmlPlayerReportGenerator(this.logger, atsvFilePath.getParent(), fileName).generateReport();
        this.logger.sendInfo("ATSV CLI report generation", "finish");
    }

    protected String parseArg() throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(this.options, this.args);
        String atsvFileValue = line.getOptionValue(this.atsvFile);
        this.validateArgument(atsvFileValue);
        return atsvFileValue;
    }

    private void validateArgument(String atsvFile) {
        Path atsvFilePath = Paths.get("", new String[0]).toAbsolutePath().resolve(TEST_PROJECT_OUTPUT_FOLDER).resolve(atsvFile);
        if (!Files.exists(atsvFilePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s ATSV file does not exist", atsvFilePath));
        }
        if (!Files.isRegularFile(atsvFilePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s ATSV file is not a file", atsvFilePath));
        }
    }
}

