/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.models;

import com.ats.tools.report.analytics.ActionType;
import com.ats.tools.report.models.ActionData;
import java.util.ArrayList;
import java.util.List;

public class PlaylistData {
    private String name;
    private long passed = 0L;
    private long failed = 0L;
    private long filtered = 0L;
    private final List<ActionData> actions;

    public PlaylistData(String name) {
        this.name = name;
        this.actions = new ArrayList<ActionData>();
        this.actions.add(new ActionData("Navigation", 0));
        this.actions.add(new ActionData("Calls", 0));
        this.actions.add(new ActionData("UserAction", 0));
        this.actions.add(new ActionData("Assertion", 0));
        this.actions.add(new ActionData("Technical", 0));
        this.actions.add(new ActionData("Others", 0));
    }

    public void addAction(String actionType) {
        String actionName = switch (ActionType.of(actionType)) {
            case ActionType.NAVIGATION -> "Navigation";
            case ActionType.CALL_SCRIPT -> "Calls";
            case ActionType.USER_ACTION -> "UserAction";
            case ActionType.ASSERT -> "Assertion";
            case ActionType.TECHNICAL -> "Technical";
            default -> "Others";
        };
        for (ActionData action : this.actions) {
            if (!action.getName().equalsIgnoreCase(actionName)) continue;
            action.setValue(action.getValue() + 1);
            return;
        }
    }

    public void addTest(long passed, long failed, long filtered) {
        this.passed = passed;
        this.failed = failed;
        this.filtered = filtered;
    }

    public String getName() {
        return this.name;
    }

    public List<ActionData> getActions() {
        return this.actions;
    }
}

