/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.summary;

import com.ats.tools.report.Constants;
import com.ats.tools.report.models.ReportSummary;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteInfo;
import com.ats.tools.report.models.SuiteSummary;
import com.ats.tools.report.models.TestSummary;
import java.util.List;

public class SummaryCalculator {
    public ReportSummary calculateReportSummary(Results results, List<Suite> suites, List<TestSummary> testSummaries) {
        long executionTime = this.calculateSuitesTotalExecutionTime(suites);
        return new ReportSummary(results.getSuitesCount(), results.getSuitesPassed(), results.getSuitesFailed(), executionTime, results.getDuration() - executionTime, results.getDuration(), null, this.calculateExecutedTestsCount(results.getSuites()), this.calculateTestsPassed(results.getSuites()), this.calculateTestsFailed(results.getSuites()), this.calculateExecutedActionsCount(testSummaries), 0);
    }

    public ReportSummary updateCalculatedActionsCount(List<Suite> suites, ReportSummary reportSummary) {
        int totalCalculatedActionsCount = suites.stream().mapToInt(suite -> suite.getSuiteSummary().calculatedActionsCount()).sum();
        return reportSummary.withNewCalculatedActionsCount(totalCalculatedActionsCount);
    }

    public SuiteSummary calculateSuiteSummary(SuiteInfo suite, List<Script> scripts) {
        int totalActionsCount = suite.getSummaries().stream().mapToInt(summary -> Integer.parseInt(summary.getActions())).sum();
        long executionTime = suite.getSummaries().stream().map(TestSummary::getExecutionTime).mapToLong(Long::parseLong).sum();
        return new SuiteSummary(suite.getTestsFailed() + suite.getTestsPassed() + suite.getTestsFiltered(), suite.getTestsPassed(), suite.getTestsFailed(), suite.getTestsFiltered(), totalActionsCount, 0, executionTime, Constants.Status.fromValue(suite.getStatus()), this.testsCountsMismatch(suite, scripts));
    }

    public SuiteSummary updateCalculatedActionsCount(SuiteInfo suite, SuiteSummary suiteSummary) {
        int totalCalculatedActionsCount = suite.getSummaries().stream().mapToInt(TestSummary::getCalculatedActionsCount).sum();
        return suiteSummary.withNewCalculatedActionsCount(totalCalculatedActionsCount);
    }

    private boolean testsCountsMismatch(SuiteInfo suite, List<Script> scripts) {
        List<Script> filteredScripts = scripts.stream().filter(script -> script.getSuite().equals(suite.getName())).toList();
        long passedScriptsCount = filteredScripts.stream().filter(Script::isPassed).count();
        long failedScriptsCount = filteredScripts.stream().filter(script -> !script.isPassed()).count();
        boolean isPassedMismatch = (long)suite.getTestsPassed() != passedScriptsCount;
        boolean isFailedMismatch = (long)suite.getTestsFailed() != failedScriptsCount;
        return isPassedMismatch || isFailedMismatch;
    }

    private long calculateSuitesTotalExecutionTime(List<Suite> suites) {
        return suites.stream().map(Suite::getSuiteSummary).mapToLong(SuiteSummary::executionTime).sum();
    }

    private int calculateExecutedTestsCount(List<SuiteInfo> suiteInfos) {
        return suiteInfos.stream().mapToInt(suiteInfo -> suiteInfo.getTestsPassed() + suiteInfo.getTestsFailed()).sum();
    }

    private int calculateTestsPassed(List<SuiteInfo> suiteInfos) {
        return suiteInfos.stream().mapToInt(SuiteInfo::getTestsPassed).sum();
    }

    private int calculateTestsFailed(List<SuiteInfo> suiteInfos) {
        return suiteInfos.stream().mapToInt(SuiteInfo::getTestsFailed).sum();
    }

    private int calculateExecutedActionsCount(List<TestSummary> testSummaries) {
        return testSummaries.stream().mapToInt(summary -> Integer.parseInt(summary.getActions())).sum();
    }
}

