/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.utils;

import com.ats.tools.report.builders.ErrorTagBuilder;
import com.ats.tools.report.builders.SearchElementCriteriaBuilder;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.ActionElement;
import com.ats.tools.report.models.TestInfo;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class HtmlActionUtils {
    private static final Pattern DIALOG_BOX_CRITERIA_PATTERN = Pattern.compile("ALERT \\[(.*?)]");
    private static final String SEARCHED_ELEMENT_TEMPLATE = "<div style=\"margin-right: 5px;\">\n    ${criterias}\n    ${searchSummary}\n</div>\n";
    private static final String SEARCHED_ELEMENT_SUMMARY_TEMPLATE = "<div style=\"font-size: 12px; color: rgba(104, 112, 125, 0.88); margin-top: 6px; font-weight: 400;\">\n    <div>Elements found: ${foundElements}</div>\n    <div>Search duration: ${searchedDuration} ms</div>\n</div>\n";

    public static String buildHtmlHeader(String header, String error) {
        return String.join((CharSequence)"&nbsp;", header, ErrorTagBuilder.buildPropertyErrorTag(error));
    }

    public static String buildSearchedElementHeader(Action action) {
        String errorTag;
        String element;
        boolean dialogTag = Optional.ofNullable(action.getActionElement()).map(ActionElement::getTag).filter("dialog"::equals).isPresent();
        if (dialogTag) {
            element = "dialog box";
            errorTag = ErrorTagBuilder.buildDialogElementErrorTag(action.getError());
        } else {
            element = "element";
            errorTag = ErrorTagBuilder.buildSearchElementErrorTag(action.getError());
        }
        return String.join((CharSequence)"&nbsp;", String.format("Searched %s", element), errorTag);
    }

    public static String buildSearchedElementData(Action action) {
        ActionElement actionElement = action.getActionElement();
        return SEARCHED_ELEMENT_TEMPLATE.replace("${criterias}", SearchElementCriteriaBuilder.buildSearchCriteria(actionElement.getTag(), actionElement.getCriterias())).replace("${searchSummary}", HtmlActionUtils.buildSearchElementSummary(action.getActionElement()));
    }

    public static String buildSearchElementSummary(ActionElement element) {
        return Objects.nonNull(element) ? SEARCHED_ELEMENT_SUMMARY_TEMPLATE.replace("${foundElements}", Integer.toString(element.getFoundElements())).replace("${searchedDuration}", Integer.toString(element.getSearchDuration())) : "";
    }

    public static String getActionUrl(Action action, TestInfo testInfo) {
        return testInfo.getProject().getProjectId() + "/script/" + action.getScript() + "/" + action.getLine();
    }

    public static String getActionUrl(TestInfo testInfo, String scriptName, String line) {
        return testInfo.getProject().getProjectId() + "/script/" + scriptName + "/" + line;
    }

    public static String buildLink(String link) {
        String linkUrl = link.startsWith("http") ? link : String.format("%s%s", "http://", link);
        return String.format("<a href=\"%s\" target=\"_blank\">%s</a>", linkUrl, link);
    }
}

