/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;

public class TimeUtil {
    private static final DecimalFormat MILLISECONDS_FORMATTER;

    private TimeUtil() {
    }

    public static long roundUpToSecond(long milliseconds) {
        return milliseconds % 1000L == 0L ? milliseconds : (milliseconds / 1000L + 1L) * 1000L;
    }

    public static String formatExecutionTime(long executionTime) {
        Duration duration = Duration.ofMillis(executionTime);
        return String.format("%02d:%02d:%02d", duration.toHours(), duration.toMinutesPart(), duration.toSecondsPart());
    }

    public static String formatMilliseconds(int milliseconds) {
        return MILLISECONDS_FORMATTER.format(milliseconds);
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator(' ');
        MILLISECONDS_FORMATTER = new DecimalFormat("#,###", symbols);
    }
}

