/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.telemetry;

import com.ats.tools.telemetry.CollectorBuilder;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Collector {
    private String endpointUrl;
    private MetricReader metricReader;
    private OpenTelemetry openTelemetry;
    private Meter meter;
    private Resource resource;
    private MetricExporter metricExporter;

    public MetricExporter getMetricExporter() {
        return this.metricExporter;
    }

    public static boolean isOpenTelemetryEnabled() {
        return CollectorBuilder.getOpenTelemetryEndpoint() != null;
    }

    public static Collector getDefault() {
        return Collector.builder().build();
    }

    public static CollectorBuilder builder() {
        return new CollectorBuilder();
    }

    public static void main(String[] args) throws InterruptedException {
        if (args.length < 1) {
            System.out.println("Usage: com.ats.tools.telemetry.Collector [COUNTER_NAME]=[VALUE]  [COUNTER_NAME=VALUE]");
            System.exit(2);
        }
        Collector collector = Collector.getDefault();
        for (String metric : args) {
            String[] parts = metric.split("=");
            if (parts.length <= 1) continue;
            String metricName = parts[0];
            String metricValue = parts[1];
            collector.addCount(metricName, Long.valueOf(metricValue));
            System.out.println("metric count " + metricName + " " + metricValue);
        }
        collector.close();
    }

    public Collector(Map<String, String> resources, MetricExporter metricExporter) {
        this.resource = Collector.mapToResource(resources);
        this.metricExporter = metricExporter;
    }

    public void addCount(String counterName, long value) {
        this.getCounter(counterName).add(value);
    }

    public void addCount(String counterName, long value, Map attributes) {
        this.getCounter(counterName).add(value, Collector.mapToAttributes(attributes));
    }

    private static Resource mapToResource(Map<String, String> attributes) {
        ResourceBuilder resourceBuilder = Resource.getDefault().toBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            resourceBuilder.put(entry.getKey(), entry.getValue());
        }
        return resourceBuilder.build();
    }

    private static Attributes mapToAttributes(Map<String, String> attributes) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributesBuilder.put(entry.getKey(), entry.getValue());
        }
        return attributesBuilder.build();
    }

    private LongCounter getCounter(String counterName) {
        return this.getMeter().counterBuilder(counterName).setUnit("1").build();
    }

    private Meter getMeter() {
        if (this.meter == null) {
            this.meter = this.getOpenTelemetry().meterBuilder("instrumentation-library-name").setInstrumentationVersion("1.0.0").build();
        }
        return this.meter;
    }

    public void close() {
        if (this.metricReader != null) {
            try {
                this.metricReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private OpenTelemetry getOpenTelemetry() {
        if (this.openTelemetry == null) {
            SdkMeterProviderBuilder sdkMeterProviderBuilder = SdkMeterProvider.builder();
            if (this.getMetricExporter() != null) {
                this.metricReader = PeriodicMetricReader.builder((MetricExporter)this.getMetricExporter()).setInterval(100L, TimeUnit.MILLISECONDS).build();
                sdkMeterProviderBuilder.registerMetricReader(this.metricReader);
            }
            if (this.resource != null) {
                sdkMeterProviderBuilder.setResource(this.resource);
            }
            SdkMeterProvider sdkMeterProvider = sdkMeterProviderBuilder.build();
            this.openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProvider).build();
        }
        return this.openTelemetry;
    }
}

